/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui.device;

import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.prop.ui.device.UIThemes;
import java.util.HashMap;
import java.util.StringTokenizer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GThemes
implements Cloneable {
    public static final int ANY = -1;
    public static final int DESKTOP = 0;
    public static final int MOBILE = 1;
    public static final GThemes NONE;
    private static final HashMap<UIThemes.Name, GThemes> a;
    private static final HashMap<UIThemes.Name, GThemes> b;
    private static final HashMap<Integer, GThemes> c;
    public static final GThemes DEFAULT_DESKTOP;
    public static final GThemes DEFAULT_MOBILE;
    public static final GThemes DEFAULT_MASK;
    public static final GThemes MOBILE_MASK;
    public static final GThemes DESKTOP_MASK;
    public static final GThemes DEFAULT_STARTUP;
    public static final GThemes ANY_MASK;
    private final int a;
    private final int b;
    private final int c;

    static {
        UIThemes.Name name;
        a = new HashMap();
        b = new HashMap();
        c = new HashMap();
        UIThemes.Name[] nameArray = UIThemes.a;
        int n2 = UIThemes.a.length;
        int n3 = 0;
        while (n3 < n2) {
            name = nameArray[n3];
            a.put(name, GThemes.from(0, new UIThemes.Name[]{name}, new UIThemes.Name[0]));
            ++n3;
        }
        nameArray = UIThemes.b;
        n2 = UIThemes.b.length;
        n3 = 0;
        while (n3 < n2) {
            name = nameArray[n3];
            b.put(name, GThemes.from(1, UIThemes.a, new UIThemes.Name[]{name}));
            ++n3;
        }
        NONE = new GThemes(-2, 0, 0);
        c.put(0, NONE);
        DEFAULT_DESKTOP = GThemes.from(0, UIThemes.DEFAULT_DESKTOP_NAMES, null);
        DEFAULT_MOBILE = GThemes.from(1, UIThemes.FLAT, UIThemes.getAllMobileThemes());
        DEFAULT_MASK = GThemes.from(-1, null, null);
        MOBILE_MASK = GThemes.from(1, null, null);
        DESKTOP_MASK = GThemes.from(0, null, null);
        DEFAULT_STARTUP = GThemes.from(-1, new UIThemes.Name[]{UIThemes.DEFAULT_DESKTOP_NAME}, new UIThemes.Name[]{UIThemes.DEFAULT_MOBILE_NAME});
        ANY_MASK = GThemes.from(-1, null, null);
    }

    public static GThemes from(int n2, UIThemes.Name[] nameArray, UIThemes.Name[] nameArray2) {
        int n3;
        return GThemes.a(n2, n3, switch (n2) {
            case 1 -> {
                n3 = UIThemes.a;
                yield UIThemes.a(nameArray2, true);
            }
            case 0 -> {
                n3 = UIThemes.a(nameArray, false);
                yield 0;
            }
            case -1 -> {
                n3 = UIThemes.a(nameArray, false);
                yield UIThemes.a(nameArray2, true);
            }
            default -> throw new IllegalArgumentException("Unknown type: " + n2);
        });
    }

    public static GThemes from(String string) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = switch (string2 = stringTokenizer.nextToken()) {
            case "type=*" -> -1;
            case "type=desktop" -> 0;
            case "type=mobile" -> 1;
            default -> throw new IllegalArgumentException("Invalid type: " + string2);
        };
        string2 = stringTokenizer.nextToken();
        if (!string2.startsWith("desktop=")) {
            throw new IllegalArgumentException("Invalid desktop theme: " + string2);
        }
        int n3 = n2 != 1 ? UIThemes.a(UIThemes.parseNames(string2.substring(8)), false) : UIThemes.a;
        UIThemes.Name[] nameArray = null;
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!string2.startsWith("mobile=")) {
                throw new IllegalArgumentException("Invalid mobile theme: " + string2);
            }
            nameArray = UIThemes.parseNames(string2.substring(7));
        }
        return GThemes.a(n2, n3, UIThemes.a(nameArray, true));
    }

    public static GThemes from(ReadTransaction readTransaction) {
        int n2 = readTransaction.readByte() - 1;
        int n3 = 0;
        int n4 = readTransaction.readUnsigned();
        while (--n4 >= 0) {
            n3 |= 1 << UIThemes.getTheme(readTransaction.readString()).ordinal();
        }
        n4 = 0;
        int n5 = readTransaction.readUnsigned();
        while (--n5 >= 0) {
            n4 |= 1 << UIThemes.getTheme(readTransaction.readString()).ordinal();
        }
        if (n2 == -1 && n3 == 0 && n4 == 0) {
            return NONE;
        }
        return GThemes.a(n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GThemes a(int n2, int n3, int n4) {
        int n5 = n2 + 2 | (n3 & 0xFF) << 2 | (n4 & 0xFF) << 10;
        HashMap<Integer, GThemes> hashMap = c;
        synchronized (hashMap) {
            GThemes gThemes = c.get(n5);
            if (gThemes == null) {
                gThemes = new GThemes(n2, n3, n4);
                c.put(n5, gThemes);
            }
            return gThemes;
        }
    }

    public static GThemes fromMobile(UIThemes.Name name) {
        if (!name.isMobile) {
            throw new IllegalArgumentException("Name is not of mobile type");
        }
        GThemes gThemes = b.get((Object)name);
        assert (gThemes != null) : "Mobile theme name not found";
        return gThemes;
    }

    public static GThemes fromDesktop(UIThemes.Name name) {
        if (name.isMobile) {
            throw new IllegalArgumentException("Name is not of desktop type");
        }
        GThemes gThemes = a.get((Object)name);
        assert (gThemes != null) : "Desktop theme name not found";
        return gThemes;
    }

    private GThemes(int n2, int n3, int n4) {
        this.a = n2;
        this.b = n3;
        this.c = n4;
    }

    public GThemes(int n2, UIThemes.Name[] nameArray, UIThemes.Name[] nameArray2) {
        int n3;
        int n4 = switch (n2) {
            case 1 -> {
                n3 = UIThemes.a;
                yield UIThemes.a(nameArray2, true);
            }
            case 0 -> {
                n3 = UIThemes.a(nameArray, false);
                yield 0;
            }
            case -1 -> {
                n3 = UIThemes.a(nameArray, false);
                yield UIThemes.a(nameArray2, true);
            }
            default -> throw new IllegalArgumentException("Unknown type: " + n2);
        };
        this.a = n2;
        this.b = n3;
        this.c = n4;
    }

    public void append(SendTransaction sendTransaction) {
        if (this.a != -2) {
            UIThemes.Name name;
            int n2;
            int n3;
            UIThemes.Name[] nameArray;
            sendTransaction.appendByte(this.a + 1);
            UIThemes.Name[] nameArray2 = this.getDesktopThemes();
            if (nameArray2 != null) {
                sendTransaction.appendUnsigned(nameArray2.length);
                nameArray = nameArray2;
                n3 = nameArray2.length;
                n2 = 0;
                while (n2 < n3) {
                    name = nameArray[n2];
                    sendTransaction.appendString(name.name);
                    ++n2;
                }
            } else {
                sendTransaction.appendUnsigned(0);
            }
            nameArray2 = this.getMobileThemes();
            if (nameArray2 != null) {
                sendTransaction.appendUnsigned(nameArray2.length);
                nameArray = nameArray2;
                n3 = nameArray2.length;
                n2 = 0;
                while (n2 < n3) {
                    name = nameArray[n2];
                    sendTransaction.appendString(name.name);
                    ++n2;
                }
            } else {
                sendTransaction.appendUnsigned(0);
            }
        } else {
            sendTransaction.appendByte(0);
            sendTransaction.appendUnsigned(0);
            sendTransaction.appendUnsigned(0);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GThemes)) {
            return false;
        }
        GThemes gThemes = (GThemes)object;
        return this.a == gThemes.a && this.b == gThemes.b && this.c == gThemes.c;
    }

    public boolean isDesktop() {
        return this.a == 0 || this.a == -1;
    }

    public boolean isMobile() {
        return this.a == 1 || this.a == -1;
    }

    public UIThemes.Name[] getDesktopThemes() {
        return UIThemes.a(this.b, false);
    }

    public UIThemes.Name[] getMobileThemes() {
        return UIThemes.a(this.c, true);
    }

    public String dataToString() {
        if (this.a == -2) {
            return "<null>";
        }
        StringBuilder stringBuilder = new StringBuilder("type=").append(this.a < 0 ? "*" : (this.a == 0 ? "desktop" : "mobile")).append(",desktop=");
        stringBuilder.append(this.b < 0 ? Character.valueOf('*') : UIThemes.a(this.b, false));
        if (this.a != -2 && (this.a != 0 || this.c != 0)) {
            stringBuilder.append(",mobile=").append(this.c < 0 ? Character.valueOf('*') : UIThemes.a(this.c, true));
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.dataToString() + "]";
    }

    private static int a(int n2, int n3) {
        if (n2 < 0) {
            return n3;
        }
        if (n3 < 0) {
            return n2;
        }
        return n2 & n3;
    }

    public GThemes computeIntersection(GThemes gThemes) {
        if (this.a == -2 || gThemes != null && gThemes.a == -2) {
            return NONE;
        }
        if (gThemes == null) {
            return this;
        }
        if (this.a == -1) {
            return gThemes.a == -1 ? ANY_MASK : gThemes;
        }
        if (this.a >= 0 && gThemes.a >= 0 && this.a != gThemes.a) {
            return NONE;
        }
        switch (this.a >= 0 ? this.a : gThemes.a) {
            case 0: {
                int n2 = GThemes.a(this.b, gThemes.b);
                return n2 == 0 ? NONE : GThemes.a(0, n2, 0);
            }
            case 1: {
                int n3 = GThemes.a(this.c, gThemes.c);
                return n3 == 0 ? NONE : GThemes.a(1, UIThemes.a, n3);
            }
        }
        int n4 = GThemes.a(this.b, gThemes.b);
        int n5 = GThemes.a(this.c, gThemes.c);
        return n4 == 0 && n5 == 0 ? NONE : GThemes.a(-1, n4, n5);
    }

    public boolean isNullMask() {
        switch (this.a) {
            case 0: {
                return this.b == 0;
            }
            case 1: {
                return this.c == 0;
            }
            case -1: {
                return this.b == 0 && this.c == 0;
            }
        }
        return true;
    }

    public String verify(GThemes gThemes) {
        Object object;
        int n2;
        Object object2;
        int n3;
        UIThemes.Name[] nameArray;
        Object object3;
        if (gThemes == null) {
            return null;
        }
        if (gThemes.isNullMask()) {
            return "null mask";
        }
        Object object4 = "";
        if (this.isDesktop()) {
            if (!gThemes.isDesktop()) {
                object4 = "desktop type is masked";
            } else {
                object3 = this.getDesktopThemes();
                if (object3 != null) {
                    nameArray = gThemes.getDesktopThemes();
                    if (nameArray == null) {
                        nameArray = UIThemes.getAllDesktopThemes();
                    }
                    int n4 = 0;
                    Object object5 = "";
                    Object object6 = object3;
                    n3 = ((UIThemes.Name[])object3).length;
                    int n5 = 0;
                    while (n5 < n3) {
                        block22: {
                            object2 = object6[n5];
                            UIThemes.Name[] nameArray2 = nameArray;
                            n2 = nameArray.length;
                            int n6 = 0;
                            while (n6 < n2) {
                                object = nameArray2[n6];
                                if (!((Enum)object2).equals(object)) {
                                    ++n6;
                                    continue;
                                }
                                break block22;
                            }
                            if (n4++ > 0) {
                                object5 = (String)object5 + " ";
                            }
                            object5 = (String)object5 + ((UIThemes.Name)((Object)object2)).name;
                        }
                        ++n5;
                    }
                    if (n4 > 0) {
                        object4 = (String)object4 + (n4 > 1 ? "desktop themes masked: " + (String)object5 : "desktop theme masked: " + (String)object5);
                    }
                }
            }
        }
        object3 = "";
        if (this.isMobile()) {
            if (!gThemes.isMobile()) {
                object3 = "mobile type is masked";
            } else {
                nameArray = this.getMobileThemes();
                if (nameArray != null) {
                    UIThemes.Name[] nameArray3 = gThemes.getMobileThemes();
                    if (nameArray3 == null) {
                        nameArray3 = UIThemes.getAllMobileThemes();
                    }
                    int n7 = 0;
                    object2 = "";
                    object = nameArray;
                    int n8 = nameArray.length;
                    n3 = 0;
                    while (n3 < n8) {
                        block23: {
                            UIThemes.Name name = object[n3];
                            UIThemes.Name[] nameArray4 = nameArray3;
                            int n9 = nameArray3.length;
                            n2 = 0;
                            while (n2 < n9) {
                                UIThemes.Name name2 = nameArray4[n2];
                                if (!name.equals((Object)name2)) {
                                    ++n2;
                                    continue;
                                }
                                break block23;
                            }
                            if (n7++ > 0) {
                                object2 = (String)object2 + " ";
                            }
                            object2 = (String)object2 + name.name;
                        }
                        ++n3;
                    }
                    if (n7 > 0) {
                        object3 = (String)object3 + (n7 > 1 ? "mobile themes masked: " + (String)object2 : "mobile theme masked: " + (String)object2);
                    }
                }
            }
        }
        return object4.isEmpty() && object3.isEmpty() ? null : (object3.isEmpty() ? object4 : (object4.isEmpty() ? object3 : (String)object4 + ", " + (String)object3));
    }

    public boolean contains(UIThemes.Name name) {
        if (name.isMobile) {
            if (!this.isMobile()) {
                return false;
            }
            return (this.c & 1 << name.ordinal()) != 0;
        }
        if (!this.isDesktop()) {
            return false;
        }
        return (this.b & 1 << name.ordinal()) != 0;
    }

    public String toClientThemesString() {
        String string = this.b < 0 ? UIThemes.DEFAULT_DESKTOP_NAME.name : UIThemes.a(this.b, false);
        String string2 = null;
        if (this.a != 0) {
            UIThemes.Name name;
            if (this.c > 0 && (name = UIThemes.getPrioritized(true, UIThemes.a(this.c, true))) != null) {
                string2 = name.name;
            }
            if (string2 == null) {
                string2 = UIThemes.DEFAULT_MOBILE_NAME.name;
            }
        }
        return string2 != null ? string + "," + string2 : string + ",";
    }
}

