/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.use;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.use.Messages;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ApiUseScanTab
extends AbstractLaunchConfigurationTab {
    static final String[] EXTENSIONS = new String[]{"*.txt"};
    SelectionListener selectionadapter = SelectionListener.widgetSelectedAdapter(e -> this.updateDialog());
    ModifyListener modifyadapter = e -> this.updateDialog();
    boolean initializing = false;
    Combo baseline;
    Combo targetCombo;
    Combo reportTypeCombo;
    Button radioBaseline = null;
    Button radioTarget = null;
    Button radioInstall = null;
    Button radioReportOnly = null;
    Button baselinesButton = null;
    Button targetsButton = null;
    Button installButton = null;
    Button considerapi = null;
    Button considerinternal = null;
    Button consideruse = null;
    Button createhtml = null;
    Button openreport = null;
    Button cleanreportlocation = null;
    Button cleanhtmllocation = null;
    ITargetHandle[] targetHandles = new ITargetHandle[0];
    Text installLocation = null;
    Text searchScope = null;
    Text targetScope = null;
    Text reportlocation = null;
    Text description = null;
    Text filterRoot = null;
    Group searchForGroup = null;
    Group searchInGroup = null;
    Group filterGroup = null;

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 768);
        GridLayout layout = (GridLayout)comp.getLayout();
        layout.makeColumnsEqualWidth = true;
        Group reportGroup = SWTFactory.createGroup(comp, Messages.ApiUseScanTab_analuze, 3, 3, 768);
        this.radioBaseline = SWTFactory.createRadioButton((Composite)reportGroup, Messages.ApiUseScanTab_api_baseline);
        this.radioBaseline.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateTarget()));
        this.baseline = SWTFactory.createCombo((Composite)reportGroup, 0x800808, 1, 769, null);
        GridData gd = (GridData)this.baseline.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        this.baseline.addSelectionListener(this.selectionadapter);
        this.baselinesButton = SWTFactory.createPushButton((Composite)reportGroup, Messages.ApiUseScanTab_baselines, null);
        this.baselinesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            int bef = this.baseline.getSelectionIndex();
            String name = null;
            if (bef >= 0) {
                name = this.baseline.getItem(bef);
            }
            SWTFactory.showPreferencePage(this.getTabShell(), "org.eclipse.pde.api.tools.ui.apiprofiles.prefpage", null);
            this.updateAvailableBaselines();
            if (this.baseline.getItemCount() == 1) {
                name = this.baseline.getItem(0);
            }
            if (name != null) {
                String[] items = this.baseline.getItems();
                int i = 0;
                while (i < items.length) {
                    if (name.equals(items[i])) {
                        this.baseline.select(i);
                        break;
                    }
                    ++i;
                }
            }
            this.updateDialog();
        }));
        this.radioTarget = SWTFactory.createRadioButton((Composite)reportGroup, Messages.ApiUseScanTab_target_definitions);
        this.radioTarget.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateTarget()));
        this.targetCombo = SWTFactory.createCombo((Composite)reportGroup, 0x800808, 1, 769, null);
        gd = (GridData)this.targetCombo.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        this.targetCombo.addSelectionListener(this.selectionadapter);
        this.targetsButton = SWTFactory.createPushButton((Composite)reportGroup, Messages.ApiUseScanTab_targets, null);
        this.targetsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            int index = this.targetCombo.getSelectionIndex();
            ITargetHandle handle = null;
            if (index >= 0) {
                handle = this.targetHandles[index];
            }
            SWTFactory.showPreferencePage(this.getTabShell(), "org.eclipse.pde.ui.TargetPlatformPreferencePage", null);
            this.updateAvailableTargets();
            if (handle != null) {
                int i = 0;
                while (i < this.targetHandles.length) {
                    if (handle.equals(this.targetHandles[i])) {
                        this.targetCombo.select(i);
                        break;
                    }
                    ++i;
                }
            }
            this.updateDialog();
        }));
        this.radioInstall = SWTFactory.createRadioButton((Composite)reportGroup, Messages.ApiUseScanTab_install_location);
        this.radioInstall.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateTarget()));
        this.installLocation = SWTFactory.createText((Composite)reportGroup, 0x800804, 1, 768);
        gd = (GridData)this.installLocation.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        this.installLocation.addModifyListener(e -> this.scheduleUpdate());
        this.installButton = SWTFactory.createPushButton((Composite)reportGroup, Messages.ApiUseScanTab_browse, null);
        this.installButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.handleFolderBrowse(this.installLocation, Messages.ApiUseScanTab_select_install_location);
            this.updateDialog();
        }));
        this.radioReportOnly = SWTFactory.createRadioButton((Composite)reportGroup, Messages.ApiUseScanTab_generate_html_only);
        gd = (GridData)this.radioReportOnly.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.radioReportOnly.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateTarget()));
        this.searchForGroup = SWTFactory.createGroup(comp, Messages.ApiUseScanTab_search_for, 2, 1, 768);
        SWTFactory.createLabel((Composite)this.searchForGroup, Messages.ApiUseScanTab_references_to, 1);
        this.targetScope = SWTFactory.createText((Composite)this.searchForGroup, 0x800804, 1, 768);
        this.targetScope.addModifyListener(this.modifyadapter);
        this.considerapi = SWTFactory.createCheckButton((Composite)this.searchForGroup, Messages.ApiUseScanTab_api_references, null, true, 2);
        this.considerapi.addSelectionListener(this.selectionadapter);
        this.considerinternal = SWTFactory.createCheckButton((Composite)this.searchForGroup, Messages.ApiUseScanTab_internal_references, null, true, 2);
        this.considerinternal.addSelectionListener(this.selectionadapter);
        this.consideruse = SWTFactory.createCheckButton((Composite)this.searchForGroup, Messages.ApiUseScanTab_illegal_api_use, null, true, 2);
        this.consideruse.addSelectionListener(this.selectionadapter);
        this.searchInGroup = SWTFactory.createGroup(comp, Messages.ApiUseScanTab_search_in, 2, 1, 768);
        gd = (GridData)this.searchInGroup.getLayoutData();
        gd.verticalAlignment = 4;
        SWTFactory.createLabel((Composite)this.searchInGroup, Messages.ApiUseScanTab_bundles_matching, 1);
        this.searchScope = SWTFactory.createText((Composite)this.searchInGroup, 0x800804, 1, 768);
        this.searchScope.addModifyListener(this.modifyadapter);
        this.filterGroup = SWTFactory.createGroup(comp, Messages.ApiUseScanTab_filters, 3, 2, 768);
        SWTFactory.createLabel((Composite)this.filterGroup, Messages.ApiUseScanTab_additionalFilters, 1);
        this.filterRoot = SWTFactory.createText((Composite)this.filterGroup, 0x800804, 1, 768);
        BidiUtils.applyBidiProcessing((Text)this.filterRoot, (String)"file");
        this.filterRoot.addModifyListener(this.modifyadapter);
        Button filterBrowse = SWTFactory.createPushButton((Composite)this.filterGroup, Messages.ApiUseScanTab_Browse, null);
        filterBrowse.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleFolderBrowse(this.filterRoot, Messages.ApiUseScanTab_FilterBrowseTitle)));
        reportGroup = SWTFactory.createGroup(comp, Messages.ApiUseScanTab_reporting, 2, 2, 768);
        Composite reportTypeComp = SWTFactory.createComposite((Composite)reportGroup, 2, 2, 1, 0, 0);
        SWTFactory.createLabel(reportTypeComp, Messages.ApiUseScanTab_reportType, 1);
        this.reportTypeCombo = SWTFactory.createCombo(reportTypeComp, 8, 1, 1808, new String[]{Messages.ApiUseScanTab_referencedBundlesReport, Messages.ApiUseScanTab_referencingBundlesReport});
        this.reportTypeCombo.addSelectionListener(this.selectionadapter);
        SWTFactory.createLabel((Composite)reportGroup, Messages.ApiUseScanTab_report_location, 2);
        this.reportlocation = SWTFactory.createText((Composite)reportGroup, 0x800804, 1, 768);
        BidiUtils.applyBidiProcessing((Text)this.reportlocation, (String)"file");
        this.reportlocation.addModifyListener(this.modifyadapter);
        gd = (GridData)this.reportlocation.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        Button browse = SWTFactory.createPushButton((Composite)reportGroup, Messages.ApiUseScanTab_brows_e_, null);
        browse.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleFolderBrowse(this.reportlocation, Messages.ApiUseScanTab_SelectDirectory)));
        this.cleanreportlocation = SWTFactory.createCheckButton((Composite)reportGroup, Messages.ApiUseScanTab_clean_report_dir, null, false, 2);
        gd = (GridData)this.cleanreportlocation.getLayoutData();
        this.cleanreportlocation.addSelectionListener(this.selectionadapter);
        gd.horizontalIndent = 10;
        this.createhtml = SWTFactory.createCheckButton((Composite)reportGroup, Messages.ApiUseScanTab_create_html_report, null, false, 2);
        this.createhtml.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.updateReportOptions();
            this.updateDialog();
        }));
        this.cleanhtmllocation = SWTFactory.createCheckButton((Composite)reportGroup, Messages.ApiUseScanTab_clean_html_report_dir, null, false, 2);
        gd = (GridData)this.cleanhtmllocation.getLayoutData();
        gd.horizontalIndent = 10;
        this.cleanhtmllocation.addSelectionListener(this.selectionadapter);
        this.openreport = SWTFactory.createCheckButton((Composite)reportGroup, Messages.ApiUseScanTab_open_report, null, false, 2);
        gd = (GridData)this.openreport.getLayoutData();
        gd.horizontalIndent = 10;
        this.openreport.setEnabled(false);
        this.openreport.addSelectionListener(this.selectionadapter);
        SWTFactory.createLabel((Composite)reportGroup, Messages.ApiUseScanTab_description, 1);
        this.description = SWTFactory.createText((Composite)reportGroup, 2624, 2, 768);
        gd = (GridData)this.description.getLayoutData();
        gd.heightHint = 40;
        this.description.addModifyListener(this.modifyadapter);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, IApiToolsHelpContextIds.API_USE_SCAN_TAB);
        this.setControl((Control)comp);
    }

    void updateDialog() {
        this.updateLaunchConfigurationDialog();
    }

    void scheduleUpdate() {
        this.scheduleUpdateJob();
    }

    Shell getTabShell() {
        return this.getShell();
    }

    void updateTarget() {
        switch (this.getTargetKind()) {
            case 2: {
                this.baseline.setEnabled(true);
                this.baselinesButton.setEnabled(true);
                this.targetCombo.setEnabled(false);
                this.targetsButton.setEnabled(false);
                this.installLocation.setEnabled(false);
                this.installButton.setEnabled(false);
                this.createhtml.setEnabled(true);
                this.cleanreportlocation.setEnabled(true);
                this.description.setEnabled(true);
                this.setGroupEnablement(this.searchForGroup, true);
                this.setGroupEnablement(this.searchInGroup, true);
                this.setGroupEnablement(this.filterGroup, true);
                break;
            }
            case 1: {
                this.baseline.setEnabled(false);
                this.baselinesButton.setEnabled(false);
                this.targetCombo.setEnabled(true);
                this.targetsButton.setEnabled(true);
                this.installLocation.setEnabled(false);
                this.installButton.setEnabled(false);
                this.createhtml.setEnabled(true);
                this.cleanreportlocation.setEnabled(true);
                this.description.setEnabled(true);
                this.setGroupEnablement(this.searchForGroup, true);
                this.setGroupEnablement(this.searchInGroup, true);
                this.setGroupEnablement(this.filterGroup, true);
                break;
            }
            case 3: {
                this.baseline.setEnabled(false);
                this.baselinesButton.setEnabled(false);
                this.targetCombo.setEnabled(false);
                this.targetsButton.setEnabled(false);
                this.installLocation.setEnabled(true);
                this.installButton.setEnabled(true);
                this.createhtml.setEnabled(true);
                this.cleanreportlocation.setEnabled(true);
                this.description.setEnabled(true);
                this.setGroupEnablement(this.searchForGroup, true);
                this.setGroupEnablement(this.searchInGroup, true);
                this.setGroupEnablement(this.filterGroup, true);
                break;
            }
            case 4: {
                this.baseline.setEnabled(false);
                this.baselinesButton.setEnabled(false);
                this.targetCombo.setEnabled(false);
                this.targetsButton.setEnabled(false);
                this.installLocation.setEnabled(false);
                this.installButton.setEnabled(false);
                this.createhtml.setSelection(true);
                this.createhtml.setEnabled(false);
                this.cleanreportlocation.setEnabled(false);
                this.description.setEnabled(false);
                this.setGroupEnablement(this.searchForGroup, false);
                this.setGroupEnablement(this.searchInGroup, false);
                this.setGroupEnablement(this.filterGroup, false);
                break;
            }
        }
        this.updateReportOptions();
        this.updateLaunchConfigurationDialog();
    }

    void updateReportOptions() {
        boolean enabled = this.createhtml.getSelection();
        this.openreport.setEnabled(enabled);
        this.cleanhtmllocation.setEnabled(enabled);
    }

    void setGroupEnablement(Group group, boolean enabled) {
        Control[] children;
        Control[] controlArray = children = group.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            element.setEnabled(enabled);
            ++n2;
        }
    }

    private int getTargetKind() {
        if (this.radioBaseline.getSelection()) {
            return 2;
        }
        if (this.radioTarget.getSelection()) {
            return 1;
        }
        if (this.radioInstall.getSelection()) {
            return 3;
        }
        if (this.radioReportOnly.getSelection()) {
            return 4;
        }
        return -1;
    }

    public String getName() {
        return Messages.ApiUseScanTab_api_use_report;
    }

    public Image getImage() {
        return ApiUIPlugin.getSharedImage("IMG_ELCL_SETUP_APITOOLS");
    }

    void updateAvailableTargets() {
        ArrayList<String> names = new ArrayList<String>();
        ITargetPlatformService service = this.getTargetService();
        if (service != null) {
            ITargetHandle[] handles = service.getTargets(null);
            ArrayList<ITargetDefinition> defs = new ArrayList<ITargetDefinition>();
            ITargetHandle[] iTargetHandleArray = handles;
            int n = handles.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetHandle handle = iTargetHandleArray[n2];
                try {
                    defs.add(handle.getTargetDefinition());
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                ++n2;
            }
            Collections.sort(defs, (o1, o2) -> {
                ITargetDefinition d1 = o1;
                ITargetDefinition d2 = o2;
                String name1 = d1.getName();
                String name2 = d2.getName();
                if (name1 == null) {
                    if (name2 == null) {
                        return d1.getHandle().toString().compareTo(d2.getHandle().toString());
                    }
                    return -1;
                }
                if (name2 == null) {
                    return 1;
                }
                return name1.compareTo(name2);
            });
            this.targetHandles = new ITargetHandle[defs.size()];
            int i = 0;
            while (i < defs.size()) {
                ITargetHandle handle;
                ITargetDefinition def = (ITargetDefinition)defs.get(i);
                this.targetHandles[i] = handle = def.getHandle();
                String name = def.getName();
                names.add(name == null ? handle.toString() : name);
                ++i;
            }
        }
        this.targetCombo.setItems(names.toArray(new String[names.size()]));
    }

    private ITargetPlatformService getTargetService() {
        return (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class);
    }

    void updateAvailableBaselines() {
        IApiBaseline[] baselines;
        HashSet<String> ids = new HashSet<String>();
        IApiBaseline[] iApiBaselineArray = baselines = ApiPlugin.getDefault().getApiBaselineManager().getApiBaselines();
        int n = baselines.length;
        int n2 = 0;
        while (n2 < n) {
            IApiBaseline apiBaseline = iApiBaselineArray[n2];
            ids.add(apiBaseline.getName());
            ++n2;
        }
        this.baseline.setItems(ids.toArray(new String[ids.size()]));
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.initializing = true;
        try {
            try {
                ITargetPlatformService service;
                this.updateAvailableBaselines();
                this.updateAvailableTargets();
                this.updateRadioButtons(configuration);
                this.restoreComboSelection(this.baseline, configuration.getAttribute("org.eclipse.pde.api.tools.ui.BASELINE_NAME", null));
                String memento = configuration.getAttribute("org.eclipse.pde.api.tools.ui.TARGET_HANDLE", null);
                if (memento != null && (service = this.getTargetService()) != null) {
                    ITargetHandle handle = service.getTarget(memento);
                    int i = 0;
                    while (i < this.targetHandles.length) {
                        if (handle.equals(this.targetHandles[i])) {
                            this.targetCombo.select(i);
                            break;
                        }
                        ++i;
                    }
                }
                if (this.targetCombo.getSelectionIndex() < 0) {
                    this.targetCombo.select(0);
                }
                this.installLocation.setText(configuration.getAttribute("org.eclipse.pde.api.tools.ui.INSTALL_PATH", ""));
                this.considerapi.setSelection(this.isSpecified(1, configuration));
                this.considerinternal.setSelection(this.isSpecified(2, configuration));
                this.consideruse.setSelection(this.isSpecified(64, configuration));
                this.filterRoot.setText(configuration.getAttribute("org.eclipse.pde.api.tools.ui.FILTER_ROOT", ""));
                int reportType = configuration.getAttribute("org.eclipse.pde.api.tools.ui.REPORT_TYPE", 1);
                if (reportType == 2) {
                    this.reportTypeCombo.select(1);
                } else {
                    this.reportTypeCombo.select(0);
                }
                this.reportlocation.setText(configuration.getAttribute("org.eclipse.pde.api.tools.ui.XML_PATH", ""));
                this.cleanreportlocation.setSelection(this.isSpecified(4, configuration));
                boolean enabled = this.isSpecified(16, configuration);
                this.createhtml.setSelection(enabled);
                this.openreport.setEnabled(enabled);
                this.cleanhtmllocation.setEnabled(enabled);
                this.openreport.setSelection(this.isSpecified(32, configuration));
                this.cleanhtmllocation.setSelection(this.isSpecified(8, configuration));
                this.searchScope.setText(configuration.getAttribute("org.eclipse.pde.api.tools.ui.SEARCH_SCOPE", ""));
                this.targetScope.setText(configuration.getAttribute("org.eclipse.pde.api.tools.ui.TARGET_SCOPE", ""));
                this.description.setText(configuration.getAttribute("org.eclipse.pde.api.tools.ui.DESCRIPTION", ""));
                this.updateTarget();
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getStatus().getMessage());
                this.initializing = false;
            }
        }
        finally {
            this.initializing = false;
        }
    }

    void updateRadioButtons(ILaunchConfiguration configuration) throws CoreException {
        int kind = configuration.getAttribute("org.eclipse.pde.api.tools.ui.TARGET_KIND", 0);
        switch (kind) {
            case 2: {
                this.radioBaseline.setSelection(true);
                this.radioTarget.setSelection(false);
                this.radioInstall.setSelection(false);
                this.radioReportOnly.setSelection(false);
                break;
            }
            case 1: {
                this.radioBaseline.setSelection(false);
                this.radioTarget.setSelection(true);
                this.radioInstall.setSelection(false);
                this.radioReportOnly.setSelection(false);
                break;
            }
            case 3: {
                this.radioBaseline.setSelection(false);
                this.radioTarget.setSelection(false);
                this.radioInstall.setSelection(true);
                this.radioReportOnly.setSelection(false);
                break;
            }
            case 4: {
                this.radioBaseline.setSelection(false);
                this.radioTarget.setSelection(false);
                this.radioInstall.setSelection(false);
                this.radioReportOnly.setSelection(true);
                break;
            }
            default: {
                int itemCount = this.baseline.getItemCount();
                if (itemCount > 0) {
                    this.radioBaseline.setSelection(true);
                    this.radioTarget.setSelection(false);
                } else {
                    this.radioBaseline.setSelection(false);
                    this.radioTarget.setSelection(true);
                    TargetPlatformHelper.getWorkspaceTargetResolved((IProgressMonitor)new NullProgressMonitor());
                    this.updateAvailableTargets();
                }
                this.radioInstall.setSelection(false);
                this.radioReportOnly.setSelection(false);
            }
        }
    }

    private boolean isSpecified(int modifier, ILaunchConfiguration configuration) throws CoreException {
        int modifiers = configuration.getAttribute("org.eclipse.pde.api.tools.ui.SEARCH_MODIFIERS", 0);
        return (modifiers & modifier) > 0;
    }

    private void restoreComboSelection(Combo combo, String value) {
        int idx = -1;
        if (value != null) {
            idx = combo.indexOf(value);
            if (idx > -1) {
                combo.select(idx);
            } else {
                combo.select(0);
            }
        } else {
            combo.select(0);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        IPath path;
        configuration.setAttribute("org.eclipse.pde.api.tools.ui.TARGET_KIND", this.getTargetKind());
        configuration.setAttribute("org.eclipse.pde.api.tools.ui.BASELINE_NAME", this.baseline.getText().trim());
        configuration.setAttribute("org.eclipse.pde.api.tools.ui.INSTALL_PATH", this.installLocation.getText().trim());
        configuration.setAttribute("org.eclipse.pde.api.tools.ui.TARGET_HANDLE", this.getTargetMemento());
        int modifiers = 0;
        modifiers = this.consider(this.openreport, 32, modifiers);
        modifiers = this.consider(this.cleanhtmllocation, 8, modifiers);
        modifiers = this.consider(this.cleanreportlocation, 4, modifiers);
        modifiers = this.consider(this.considerapi, 1, modifiers);
        modifiers = this.consider(this.considerinternal, 2, modifiers);
        modifiers = this.consider(this.consideruse, 64, modifiers);
        modifiers = this.consider(this.createhtml, 16, modifiers);
        configuration.setAttribute("org.eclipse.pde.api.tools.ui.SEARCH_MODIFIERS", modifiers);
        String filterRoot = this.filterRoot.getText().trim();
        if (filterRoot.length() > 0) {
            path = IPath.fromOSString((String)filterRoot);
            configuration.setAttribute("org.eclipse.pde.api.tools.ui.FILTER_ROOT", path.toPortableString());
        } else {
            configuration.removeAttribute("org.eclipse.pde.api.tools.ui.FILTER_ROOT");
        }
        path = IPath.fromOSString((String)this.reportlocation.getText().trim());
        configuration.setAttribute("org.eclipse.pde.api.tools.ui.XML_PATH", path.toPortableString());
        configuration.setAttribute("org.eclipse.pde.api.tools.ui.SEARCH_SCOPE", this.searchScope.getText().trim());
        configuration.setAttribute("org.eclipse.pde.api.tools.ui.TARGET_SCOPE", this.targetScope.getText().trim());
        configuration.setAttribute("org.eclipse.pde.api.tools.ui.DESCRIPTION", this.description.getText().trim());
        if (this.reportTypeCombo.getSelectionIndex() == 1) {
            configuration.setAttribute("org.eclipse.pde.api.tools.ui.REPORT_TYPE", 2);
        } else {
            configuration.setAttribute("org.eclipse.pde.api.tools.ui.REPORT_TYPE", 1);
        }
    }

    private String getTargetMemento() {
        ITargetHandle handle = this.getTargetHandle();
        if (handle == null) {
            return null;
        }
        try {
            return handle.getMemento();
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
            return null;
        }
    }

    private ITargetHandle getTargetHandle() {
        int index = this.targetCombo.getSelectionIndex();
        if (index >= 0) {
            return this.targetHandles[index];
        }
        return null;
    }

    private int consider(Button button, int mask, int modifiers) {
        if (button.getSelection()) {
            return modifiers | mask;
        }
        return modifiers;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        int modifiers = 2;
        configuration.setAttribute("org.eclipse.pde.api.tools.ui.SEARCH_MODIFIERS", modifiers);
        configuration.setAttribute("org.eclipse.pde.api.tools.ui.REPORT_TYPE", 1);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (this.initializing) {
            return true;
        }
        this.setErrorMessage(null);
        String text = this.reportlocation.getText().trim();
        if ("".equals(text)) {
            this.setErrorMessage(Messages.ApiUseScanTab_enter_report_location);
            return false;
        }
        if (!(this.considerapi.getSelection() || this.considerinternal.getSelection() || this.consideruse.getSelection())) {
            this.setErrorMessage(Messages.ApiUseScanTab_must_search_something);
            return false;
        }
        text = this.searchScope.getText().trim();
        try {
            Pattern.compile(text);
        }
        catch (PatternSyntaxException pse) {
            this.setErrorMessage(NLS.bind((String)Messages.ApiUseScanTab_regex_problem, (Object)pse.getPattern()));
            return false;
        }
        text = this.targetScope.getText().trim();
        try {
            Pattern.compile(text);
        }
        catch (PatternSyntaxException pse) {
            this.setErrorMessage(NLS.bind((String)Messages.ApiUseScanTab_regex_problem, (Object)pse.getPattern()));
            return false;
        }
        return true;
    }

    void handleFolderBrowse(Text text, String message) {
        String newpath;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage(message);
        String loctext = text.getText().trim();
        if (loctext.length() > 0) {
            dialog.setFilterPath(loctext);
        }
        if ((newpath = dialog.open()) != null) {
            text.setText(newpath);
        }
    }
}

