/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.user;

import com.iizix.NotFoundException;
import com.iizix.gyro.IAppSessionGyro;
import com.iizix.server.user.AuthenticatedUser;
import com.iizix.server.user.UserAuthentication;
import com.iizix.urn.user.IUserProfileStringURNProvider;
import com.iizix.user.SessionUserIdentifier;
import java.sql.SQLException;
import java.util.Map;

public class UserProfileStringURNProvider
implements IUserProfileStringURNProvider {
    private static UserProfileStringURNProvider a = new UserProfileStringURNProvider();

    public static IUserProfileStringURNProvider getInstance() {
        return a;
    }

    public Map<String, String> getDetails(long l, boolean bl) throws NotFoundException {
        AuthenticatedUser authenticatedUser;
        if (l == -1L) {
            SessionUserIdentifier sessionUserIdentifier = IAppSessionGyro.getSessionInstance().getSessionUserIdentifier();
            if (sessionUserIdentifier == null) {
                throw new NotFoundException("User ID is not currently available in this state of the app");
            }
            String string = sessionUserIdentifier.getUserID();
            if (string == null) {
                throw new NotFoundException("User has not yet logged in with the app");
            }
            authenticatedUser = UserAuthentication.getInstance().getUser(string);
        } else {
            authenticatedUser = UserAuthentication.getInstance().getUser(l);
        }
        if (authenticatedUser == null) {
            throw new NotFoundException("User ID " + l + " does not exist");
        }
        try {
            return authenticatedUser.getBasicUserInfo().getDetails(bl);
        }
        catch (SQLException sQLException) {
            throw new NotFoundException("Failed retrieving database information for user ID " + l, (Throwable)sQLException);
        }
    }

    public Map<String, String> getDetails(String string, boolean bl) throws NotFoundException {
        Object object;
        if (string == null) {
            object = IAppSessionGyro.getSessionInstance().getSessionUserIdentifier();
            if (object == null) {
                throw new NotFoundException("User ID is not currently available in this state of the app");
            }
            string = object.getUserID();
            if (string == null) {
                throw new NotFoundException("User has not yet logged in with the app");
            }
        }
        if ((object = UserAuthentication.getInstance().getUser(string)) == null) {
            throw new NotFoundException("User name \"" + string + "\" is not found");
        }
        try {
            return ((AuthenticatedUser)object).getBasicUserInfo().getDetails(bl);
        }
        catch (SQLException sQLException) {
            throw new NotFoundException("Failed retrieving database information for user name \"" + string + "\"");
        }
    }
}

