/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.user;

import com.iizix.ILog;
import com.iizix.NotFoundException;
import com.iizix.Utilities;
import com.iizix.gyro.IAppSessionGyro;
import com.iizix.gyro.IClientSessionGyro;
import com.iizix.gyro.IRuntimeImageCache;
import com.iizix.prop.image.ClientImageData;
import com.iizix.prop.image.RuntimeImageDefinition;
import com.iizix.server.ServerShell;
import com.iizix.server.db.BasicUserInfo;
import com.iizix.server.db.DBUtilities;
import com.iizix.server.geo.UserLocationHistory;
import com.iizix.server.prop.ServerSettings;
import com.iizix.server.user.UserAuthentication;
import com.iizix.server.user.a;
import com.iizix.server.wsfile.WSFileProvider;
import com.iizix.server.wsfile.WSFileProviderEngine;
import com.iizix.urn.URNResourceType;
import com.iizix.user.IAuthenticatedUser;
import com.iizix.user.IBasicUserInfoDetailNames;
import com.iizix.user.UserLocaleString;
import com.iizix.wsfile.IWSFile;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import net.coobird.thumbnailator.Thumbnails;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AuthenticatedUser
implements IAuthenticatedUser,
IBasicUserInfoDetailNames {
    public static final String PROFILE_IMAGE_FILE_NAME_BASE = "profileImage";
    static final double[] a = new double[]{1.0};
    static final double[] b = new double[]{1.0, 1.5, 2.0, 3.0, 4.0};
    public static final String UNDEFINED_USER_PROFILE_IMAGE = "images/user-2000.png";
    public static final String ADMIN_PROFILE_IMAGE = "images/admin-720.png";
    public static final String ADMIN_BACKUP_PROFILE_IMAGE = "images/admin-backup-720.png";
    private static File a;
    private static WSFileProviderEngine a;
    private static ServerSettings a;
    private static AuthenticatedUser a;
    public final String userName;
    private BasicUserInfo a;
    private final String a;
    private WSFileProvider a;
    private UserLocationHistory a;
    private final HashMap<String, RuntimeImageDefinition> a;
    private long a;
    final IRuntimeImageCache a = new a(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static File getUndefinedUserProfileImage() throws FileNotFoundException {
        File file = a;
        if (file == null) {
            Class<AuthenticatedUser> clazz = AuthenticatedUser.class;
            // MONITORENTER : com.iizix.server.user.AuthenticatedUser.class
            file = a;
            if (file == null) {
                String string = ServerShell.getInstance().getRootDirectory();
                if (string == null) {
                    throw new FileNotFoundException("Web server is not started");
                }
                File file2 = new File(string);
                if (!file2.isDirectory()) {
                    throw new FileNotFoundException("Web server root is not found: " + string);
                }
                a = file = new File(file2, UNDEFINED_USER_PROFILE_IMAGE);
            }
            // MONITOREXIT : clazz
        }
        if (file.isFile()) return file;
        throw new FileNotFoundException("Undefined profile image file not found: " + file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static File getUndefinedUserProfileImage(File file) throws FileNotFoundException {
        File file2 = a;
        if (file2 == null) {
            Class<AuthenticatedUser> clazz = AuthenticatedUser.class;
            // MONITORENTER : com.iizix.server.user.AuthenticatedUser.class
            file2 = a;
            if (file2 == null) {
                if (!file.isDirectory()) {
                    throw new FileNotFoundException("Web server root is not found: " + String.valueOf(file));
                }
                a = file2 = new File(file, UNDEFINED_USER_PROFILE_IMAGE);
            }
            // MONITOREXIT : clazz
        }
        if (file2.isFile()) return file2;
        throw new FileNotFoundException("Undefined profile image file not found: " + file2.getAbsolutePath());
    }

    public static synchronized AuthenticatedUser getUndefinedUser() {
        if (a == null) {
            a = new AuthenticatedUser(null);
        }
        return a;
    }

    AuthenticatedUser(BasicUserInfo basicUserInfo) {
        this.userName = basicUserInfo != null ? basicUserInfo.userName : "_undef_";
        this.a = basicUserInfo;
        this.a = basicUserInfo != null ? Long.toString(basicUserInfo.id) + "-" + Utilities.getFileSystemValidString((String)this.userName) : "_undef_";
    }

    public void markAccessed() {
        this.a = System.currentTimeMillis();
    }

    public long getLastAccessedTime() {
        return this.a;
    }

    public int hashCode() {
        BasicUserInfo basicUserInfo = this.a;
        return basicUserInfo != null ? ((Object)((Object)basicUserInfo)).hashCode() : a.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof AuthenticatedUser) {
            AuthenticatedUser authenticatedUser = (AuthenticatedUser)object;
            BasicUserInfo basicUserInfo = this.a;
            BasicUserInfo basicUserInfo2 = authenticatedUser.a;
            return basicUserInfo != null && basicUserInfo2 != null ? basicUserInfo.id == basicUserInfo2.id : basicUserInfo == null && basicUserInfo2 == null;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName()).append("[user=").append(this.userName);
        BasicUserInfo basicUserInfo = this.a;
        if (basicUserInfo != null) {
            stringBuilder.append(',').append((Object)basicUserInfo);
        } else {
            stringBuilder.append("undefined");
        }
        return stringBuilder.append(']').toString();
    }

    public boolean isUndefined() {
        return this.a == null;
    }

    public BasicUserInfo getBasicUserInfo() {
        return this.a;
    }

    void a(BasicUserInfo basicUserInfo) {
        this.a = basicUserInfo;
        this.markAccessed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UserLocaleString changeEmail(String string, String string2) throws SQLException, NotFoundException {
        String string3;
        if (string == null) {
            throw new NullPointerException("newEmail is null");
        }
        if (string2 == null) {
            throw new NullPointerException("password is null");
        }
        BasicUserInfo basicUserInfo = this.getBasicUserInfo();
        if (basicUserInfo.email != null && basicUserInfo.userNameLower.equals(string3 = basicUserInfo.email.toLowerCase(Locale.ENGLISH))) {
            throw new IllegalStateException("Email change for user name that is the email is currently not supported");
        }
        UserLocaleString userLocaleString = basicUserInfo.getDisabledReason();
        if (userLocaleString != null) {
            return userLocaleString;
        }
        if (!UserAuthentication.getInstance().isOldPasswordMatching(basicUserInfo, string2)) {
            return UserLocaleString.HashedPasswordMismatch;
        }
        Throwable throwable = null;
        Object var6_8 = null;
        try {
            Connection connection = DBUtilities.getPooledConnection();
            try {
                try (PreparedStatement preparedStatement = connection.prepareStatement("UPDATE IZS.USERS SET email=? where uid=?");){
                    preparedStatement.setString(1, string);
                    preparedStatement.setLong(2, basicUserInfo.id);
                    preparedStatement.executeUpdate();
                    connection.commit();
                    basicUserInfo = BasicUserInfo.newBasicUserInfo(connection, basicUserInfo.id);
                    this.a(basicUserInfo);
                }
                if (connection == null) return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            connection.close();
            return null;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public boolean removeAccount(Connection connection) throws SQLException, IllegalStateException {
        int n;
        BasicUserInfo basicUserInfo = this.a;
        if (basicUserInfo == null) {
            throw new IllegalStateException("BasicUserInfo is null");
        }
        String string = basicUserInfo.userName;
        if (string.equalsIgnoreCase("iiziAdmin") || string.equalsIgnoreCase("iiziAdmin BACKUP")) {
            throw new IllegalStateException("Cannot remove account for user name " + string);
        }
        long l = basicUserInfo.id;
        try (PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM IZS.USERS where uid=" + l);){
            n = preparedStatement.executeUpdate();
            connection.commit();
        }
        UserAuthentication.getInstance().a(connection, basicUserInfo);
        return n > 0;
    }

    public synchronized UserLocationHistory getLocationHistory() {
        if (this.a == null) {
            throw new IllegalStateException("undefined user");
        }
        if (this.a == null) {
            this.a = new UserLocationHistory(this);
        }
        return this.a;
    }

    public WSFileProvider getUserFileProvider() throws IOException {
        return this.getUserFileProvider(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSFileProvider getUserFileProvider(WSFileProviderEngine wSFileProviderEngine) throws IOException {
        WSFileProvider wSFileProvider = this.a;
        if (wSFileProvider == null || wSFileProvider.isDisposed()) {
            AuthenticatedUser authenticatedUser = this;
            synchronized (authenticatedUser) {
                wSFileProvider = this.a;
                if (wSFileProvider == null || wSFileProvider.isDisposed()) {
                    Object object = null;
                    Long l = this.a != null ? this.a.id : -1L;
                    if (wSFileProviderEngine == null) {
                        ServerShell serverShell = ServerShell.getInstance();
                        if (serverShell == null) {
                            throw new IllegalStateException("Server is stopped or not started");
                        }
                        object = serverShell.getServerSettings();
                        wSFileProviderEngine = serverShell.getFileProviderEngine();
                        if (wSFileProviderEngine == null) {
                            throw new IllegalStateException("Server File Provider Engine is not initialized yet");
                        }
                    } else if (a == null) {
                        a = wSFileProviderEngine;
                        object = a;
                        if (object == null) {
                            object = a = new ServerSettings();
                        }
                    } else {
                        object = a;
                    }
                    if (this.userName != null) {
                        wSFileProvider = this.a = wSFileProviderEngine.getCreateFileProvider(URNResourceType.USER_DATABASE_FILES, this.userName, this.a, l, true, (ServerSettings)((Object)object));
                    }
                }
            }
        }
        return wSFileProvider;
    }

    public Map<String, IWSFile> loadAllUserFiles() throws IOException {
        Path path2;
        StringBuilder stringBuilder;
        WSFileProvider wSFileProvider = this.getUserFileProvider();
        File file = wSFileProvider.getRoot();
        LinkedHashMap<String, IWSFile> linkedHashMap = new LinkedHashMap<String, IWSFile>();
        StringBuilder stringBuilder2 = stringBuilder = ILog.getLogLevel() <= 6 ? new StringBuilder() : null;
        if (stringBuilder != null) {
            stringBuilder.append("User \"").append(this.userName).append("\" private files:");
        }
        try {
            path2 = file.toPath();
        }
        catch (InvalidPathException invalidPathException) {
            throw new IOException("Invalid directory path \"" + String.valueOf(file) + "\": " + invalidPathException.getMessage());
        }
        Files.list(path2).forEach(path -> {
            String string = path.getFileName().toString();
            if (stringBuilder != null) {
                stringBuilder.append("\n - ").append(string);
            }
            linkedHashMap.put(string, null);
        });
        if (stringBuilder != null) {
            if (linkedHashMap.isEmpty()) {
                stringBuilder.append(" (none)");
            }
            ILog.FINER(this.getClass(), (String)stringBuilder.toString());
        }
        return linkedHashMap;
    }

    public IWSFile setProfileImage(Connection connection, String string, File file) throws IOException, SQLException {
        return this.setProfileImage(null, connection, string, file);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    public IWSFile setProfileImage(WSFileProviderEngine wSFileProviderEngine, Connection connection, String string, File file) throws IOException, SQLException {
        if (this.a == null) {
            throw new IllegalStateException("Undefined user: cannot set profile image");
        }
        switch (string) {
            default: {
                throw new IllegalArgumentException("Invalid profile image detail: " + string);
            }
            case "IZS-LargeImage": 
            case "IZS-ThumbnailImage": 
            case "IZS-UploadImage": 
        }
        Object object = this.getUserFileProvider(wSFileProviderEngine);
        String string2 = file.getName();
        IWSFile iWSFile = ((WSFileProvider)object).getFileFromFileName(string2);
        IWSFile iWSFile2 = ((WSFileProvider)object).reserveFile(file, "Profile image for " + this.userName, this.a.id);
        this.a.setUserDetail(connection, string, string2);
        if (iWSFile != null) {
            iWSFile.delete();
            ILog.FINER(this.getClass(), (String)("Updated user \"" + this.userName + "\" " + string + " to " + file.getAbsolutePath() + " from " + iWSFile.getPublishedFile().getAbsolutePath()));
        } else {
            ILog.FINER(this.getClass(), (String)("Added user \"" + this.userName + "\" " + string + " to " + file.getAbsolutePath()));
        }
        this.a.clearImageCache();
        return iWSFile2;
    }

    public String getProfileImageName(int n, int n2, int n3) {
        return this.getProfileImageName(n, n2, n3, 0);
    }

    public String getProfileImageName(int n, int n2, int n3, int n4) {
        StringBuilder stringBuilder = new StringBuilder(this.a).append('-').append(PROFILE_IMAGE_FILE_NAME_BASE).append('-').append(n).append('x').append(n2);
        if (n3 == 0) {
            stringBuilder.append(".png");
        } else {
            stringBuilder.append('-').append(n3).append(".jpg");
        }
        return stringBuilder.toString();
    }

    public RuntimeImageDefinition getProfileImage(IClientSessionGyro iClientSessionGyro, int n, int n2, int n3) throws IOException {
        double[] dArray;
        double d2 = iClientSessionGyro.getEnvironment().getDPR();
        if (d2 == 1.0) {
            dArray = a;
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = 1.0;
            dArray = dArray2;
            dArray2[1] = d2;
        }
        double[] dArray3 = dArray;
        return this.a((IRuntimeImageCache)iClientSessionGyro, n, n2, n3, true, 0, dArray3);
    }

    public RuntimeImageDefinition getProfileImage(IClientSessionGyro iClientSessionGyro, int n, int n2, int n3, int n4) throws IOException {
        double[] dArray;
        double d2 = iClientSessionGyro.getEnvironment().getDPR();
        if (d2 == 1.0) {
            dArray = a;
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = 1.0;
            dArray = dArray2;
            dArray2[1] = d2;
        }
        double[] dArray3 = dArray;
        return this.a((IRuntimeImageCache)iClientSessionGyro, n, n2, n3, true, n4, dArray3);
    }

    public RuntimeImageDefinition getProfileImage(IAppSessionGyro iAppSessionGyro, int n, int n2, int n3, boolean bl) throws IOException {
        return this.a((IRuntimeImageCache)iAppSessionGyro, n, n2, n3, bl, 0, b);
    }

    public RuntimeImageDefinition getProfileImage(IAppSessionGyro iAppSessionGyro, int n, int n2, int n3, boolean bl, int n4) throws IOException {
        return this.a((IRuntimeImageCache)iAppSessionGyro, n, n2, n3, bl, n4, b);
    }

    public RuntimeImageDefinition getProfileImage(int n, int n2, int n3, boolean bl) throws IOException {
        return this.a(this.a, n, n2, n3, bl, 0, b);
    }

    public RuntimeImageDefinition getProfileImage(int n, int n2, int n3, boolean bl, int n4) throws IOException {
        return this.a(this.a, n, n2, n3, bl, n4, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    RuntimeImageDefinition a(IRuntimeImageCache iRuntimeImageCache, int n, int n2, int n3, boolean bl, int n4, double[] dArray) throws IOException {
        WSFileProvider wSFileProvider;
        if (n < 16) throw new IllegalArgumentException("Invalid width (16-400): " + n);
        if (n > 400) {
            throw new IllegalArgumentException("Invalid width (16-400): " + n);
        }
        if (n2 < 16) throw new IllegalArgumentException("Invalid height (16-400): " + n2);
        if (n2 > 400) {
            throw new IllegalArgumentException("Invalid height (16-400): " + n2);
        }
        if (n3 < 0) throw new IllegalArgumentException("Invalid quality (0-100): " + n3);
        if (n3 > 100) {
            throw new IllegalArgumentException("Invalid quality (0-100): " + n3);
        }
        this.markAccessed();
        ClientImageData clientImageData = null;
        String string = null;
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        WSFileProvider wSFileProvider2 = wSFileProvider = this.getUserFileProvider();
        synchronized (wSFileProvider2) {
            double[] dArray2 = dArray;
            int n5 = dArray.length;
            int n6 = 0;
            while (n6 < n5) {
                File file;
                double d2 = dArray2[n6];
                int n7 = (int)((double)n * d2);
                int n8 = (int)((double)n2 * d2);
                String string5 = "profileImage-" + n7 + "x" + n8;
                string5 = n3 == 0 ? string5 + ".png" : string5 + "-" + n3 + ".jpg";
                if (string == null && (file = iRuntimeImageCache.getImage(string = this.a + "-" + string5)) != null) {
                    return file;
                }
                file = wSFileProvider.getRoot();
                IWSFile iWSFile = wSFileProvider.getFileFromFileName(string5);
                if (iWSFile == null) {
                    Object object;
                    Connection connection;
                    Object object2 = null;
                    if (this.a != null) {
                        block49: {
                            try {
                                if (!bl2) {
                                    bl2 = true;
                                    connection = DBUtilities.getPooledConnection();
                                    try {
                                        try {
                                            object = this.a.getDetails(connection, false);
                                            try {
                                                connection.commit();
                                            }
                                            catch (SQLException sQLException) {}
                                        }
                                        catch (SQLException sQLException) {
                                            try {
                                                connection.rollback();
                                                throw sQLException;
                                            }
                                            catch (SQLException sQLException2) {
                                                // empty catch block
                                            }
                                            throw sQLException;
                                        }
                                    }
                                    finally {
                                        connection.close();
                                    }
                                    string2 = (String)object.get("IZS-ThumbnailImage");
                                    string3 = (String)object.get("IZS-LargeImage");
                                    string4 = (String)object.get("IZS-UploadImage");
                                }
                                if (n7 <= 150 && n8 <= 150 && string2 != null && ((File)(object = new File(file, string2))).isFile()) {
                                    object2 = object;
                                }
                                if (object2 != null) break block49;
                                if (string3 != null && ((File)(object = new File(file, string3))).isFile()) {
                                    object2 = object;
                                }
                                if (object2 == null && string4 != null && ((File)(object = new File(file, string4))).isFile()) {
                                    object2 = object;
                                }
                            }
                            catch (SQLException sQLException) {
                                ILog.SEVERE(this.getClass(), (String)("Failed loading user details information for user \"" + this.userName + "\": " + sQLException.getMessage()));
                            }
                        }
                        if (object2 == null && bl) {
                            return AuthenticatedUser.getUndefinedUser().a(iRuntimeImageCache, n, n2, n3, false, n4, dArray);
                        }
                    } else {
                        try {
                            object2 = AuthenticatedUser.getUndefinedUserProfileImage();
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            ILog.WARNING(this.getClass(), (String)fileNotFoundException.getMessage());
                            return null;
                        }
                    }
                    if (object2 != null) {
                        object = new File(file, string5);
                        if (n4 == 0) {
                            connection = Thumbnails.of((File[])new File[]{object2}).size(n7, n8);
                            if (n3 == 0) {
                                connection.outputFormat("png");
                            } else {
                                connection.outputFormat("jpg").outputQuality((float)n3 / 100.0f);
                            }
                            connection.toFile((File)object);
                        } else {
                            double d3;
                            double d4;
                            connection = Thumbnails.of((File[])new File[]{object2}).size(n7, n8);
                            if (n4 < 0) {
                                d4 = (double)n7 / 2.0;
                                d3 = (double)n8 / 2.0;
                            } else {
                                d4 = d3 = (double)n4 * d2;
                            }
                            BufferedImage bufferedImage = new BufferedImage(n7, n8, 2);
                            Graphics2D graphics2D = bufferedImage.createGraphics();
                            graphics2D.setComposite(AlphaComposite.Clear);
                            if (n3 == 0) {
                                graphics2D.fillRect(0, 0, n7, n8);
                            } else {
                                graphics2D.setColor(Color.WHITE);
                            }
                            graphics2D.setComposite(AlphaComposite.SrcOver);
                            graphics2D.drawImage((Image)connection.asBufferedImage(), 0, 0, null);
                            connection = null;
                            graphics2D.setPaint(new TexturePaint(bufferedImage, new Rectangle2D.Float(0.0f, 0.0f, n7, n8)));
                            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            graphics2D.fill(new RoundRectangle2D.Double(0.0, 0.0, n7, n8, d4, d3));
                            graphics2D.setPaint(null);
                            graphics2D.dispose();
                            Thumbnails.Builder builder = Thumbnails.of((BufferedImage[])new BufferedImage[]{bufferedImage});
                            if (n3 == 0) {
                                builder.outputFormat("png");
                            } else {
                                builder.outputFormat("jpg").outputQuality((float)n3 / 100.0f);
                            }
                            builder.toFile((File)object);
                        }
                        try {
                            iWSFile = wSFileProvider.reserveFile((File)object, "Profile image", this.a.id);
                        }
                        catch (NotFoundException notFoundException) {
                            // empty catch block
                        }
                    }
                }
                if (iWSFile == null) break;
                iWSFile.publish();
                if (clientImageData == null) {
                    clientImageData = new ClientImageData(iWSFile.getFullTargetURL(), this.userName, n, n2);
                } else {
                    clientImageData.createSingleResolution(d2, iWSFile.getFullTargetURL(), n7, n8);
                }
                ++n6;
            }
            if (clientImageData == null) {
                return null;
            }
        }
        wSFileProvider2 = iRuntimeImageCache;
        synchronized (wSFileProvider2) {
            RuntimeImageDefinition runtimeImageDefinition = iRuntimeImageCache.getImage(string);
            if (runtimeImageDefinition != null) return runtimeImageDefinition;
            runtimeImageDefinition = new RuntimeImageDefinition(string, clientImageData);
            iRuntimeImageCache.setImage(runtimeImageDefinition);
            return runtimeImageDefinition;
        }
    }

    public File getProfilePictureFile() throws IOException {
        return this.getProfilePictureFile((String[])null);
    }

    public File getProfilePictureFile(String[] stringArray) throws IOException {
        File file;
        BasicUserInfo basicUserInfo;
        if (stringArray != null) {
            stringArray[0] = null;
        }
        if ((basicUserInfo = this.a) == null) {
            return null;
        }
        WSFileProvider wSFileProvider = this.getUserFileProvider();
        File file2 = wSFileProvider.getRoot();
        Map<String, String> map = basicUserInfo.getDetails();
        String string = map.get("IZS-UploadImage");
        if (string != null && (file = new File(file2, string)).isFile()) {
            if (stringArray != null) {
                stringArray[0] = "IZS-UploadImage";
            }
            return file;
        }
        string = map.get("IZS-LargeImage");
        if (string != null && (file = new File(file2, string)).isFile()) {
            if (stringArray != null) {
                stringArray[0] = "IZS-LargeImage";
            }
            return file;
        }
        string = map.get("IZS-ThumbnailImage");
        if (string != null && (file = new File(file2, string)).isFile()) {
            if (stringArray != null) {
                stringArray[0] = "IZS-ThumbnailImage";
            }
            return file;
        }
        return null;
    }

    public File getProfilePictureFile(String string) throws IOException {
        if (string.equals("IZS-UploadImage") || string.equals("IZS-LargeImage") || string.equals("IZS-ThumbnailImage")) {
            File file;
            WSFileProvider wSFileProvider = this.getUserFileProvider();
            File file2 = wSFileProvider.getRoot();
            Map<String, String> map = this.a.getDetails();
            String string2 = map.get(string);
            if (string2 != null && (file = new File(file2, string2)).isFile()) {
                return file;
            }
        }
        return null;
    }
}

