/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.push;

import com.iizix.ILog;
import com.iizix.NotFoundException;
import com.iizix.Utilities;
import com.iizix.comm.PortConfig;
import com.iizix.prop.PushProps;
import com.iizix.server.ServerShell;
import com.iizix.server.app.AppFactory;
import com.iizix.server.app.SystemApp;
import com.iizix.server.db.DBFunctions;
import com.iizix.server.user.AuthenticatedUser;
import com.iizix.server.user.UserAuthentication;
import com.iizix.web.ICommonServletInterface;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class PushNotificationHandler
implements ICommonServletInterface {
    public static final String BASE_REQUEST_URI = "/iizi-push/";
    public static final String HEADER = "X-iizi";
    public static final String AUTH_REALM = "Push Notifications";
    public static final String KEYS = "keys";
    public static final String SUBSCRIPTION_COUNT = "count";
    public static final String GET_SUBSCRIPTIONS = "get_subs";
    public static final String RESET = "reset";
    public static final String SUBSCRIPTIONS_LIST = "list";
    public static final String SUBSCRIBE = "subscribe";
    public static final String UNSUBSCRIBE = "unsubscribe";
    public static final String PUSH = "push";
    public static final String APP_ID_NOT_FOUND = "App ID not found";
    public static final String SERVER_NO_KEYS = "Server is not configured for push notification";
    public static final String APP_ERR_NO_KEYS = "Application is not configured for push notification";
    public static final String NO_SUBSCRIPTIONS_ERR = "Missing subscriptions";
    public static final String INVALID_SUBSCRIPTION_ERR = "Invalid subscription";
    private static final int a = "/iizi-push/".length();
    private final ServerShell a;
    private int b;

    PushNotificationHandler(ServerShell serverShell) {
        this.a = serverShell;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handle(String string, PortConfig portConfig, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        boolean bl = false;
        if (!string.startsWith(BASE_REQUEST_URI)) return bl;
        if (string.length() <= a) return bl;
        System.out.println("WS-Request = " + String.valueOf(httpServletRequest.getRequestURL()));
        if (!"POST".equals(httpServletRequest.getMethod())) return bl;
        String string2 = httpServletRequest.getHeader(HEADER);
        if (string2 == null) {
            ILog.WARNING(this.getClass(), (String)("REST push notification request " + string + " from " + httpServletRequest.getRemoteAddr() + " does not specify the 'X-iizi' header for the Device ID"));
            httpServletResponse.sendError(400);
            return true;
        }
        try {
            UUID.fromString(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ILog.WARNING(this.getClass(), (String)("REST push notification request " + string + " from " + httpServletRequest.getRemoteAddr() + " has an invalid 'X-iizi' header, invalid UUID: '" + string2 + "'"));
            httpServletResponse.sendError(400);
            return true;
        }
        try {
            Throwable throwable = null;
            Object var8_11 = null;
            try (BufferedReader bufferedReader = httpServletRequest.getReader();){
                JSONObject jSONObject = new JSONObject(new JSONTokener((Reader)bufferedReader));
                Object object = httpServletRequest.getHeaderNames();
                while (object.hasMoreElements()) {
                    String string3 = (String)object.nextElement();
                    Enumeration enumeration = httpServletRequest.getHeaders(string3);
                    while (enumeration.hasMoreElements()) {
                        System.out.println(" - " + string3 + " = " + (String)enumeration.nextElement());
                    }
                }
                System.out.println("WS-Request from " + httpServletRequest.getRemoteAddr() + ", device = " + string2 + ", JSON =\n" + jSONObject.toString(2) + "\n");
                switch (string.substring(a)) {
                    case "keys": {
                        bl = this.a(string2, jSONObject, httpServletRequest, httpServletResponse);
                        return bl;
                    }
                    case "reset": {
                        bl = this.b(string2, jSONObject, httpServletRequest, httpServletResponse);
                        return bl;
                    }
                    case "count": {
                        bl = this.c(string2, jSONObject, httpServletRequest, httpServletResponse);
                        return bl;
                    }
                    case "list": {
                        bl = this.d(string2, jSONObject, httpServletRequest, httpServletResponse);
                        return bl;
                    }
                    case "subscribe": {
                        bl = this.e(string2, jSONObject, httpServletRequest, httpServletResponse);
                        return bl;
                    }
                    case "unsubscribe": {
                        bl = this.f(string2, jSONObject, httpServletRequest, httpServletResponse);
                        return bl;
                    }
                    case "get_subs": {
                        bl = this.g(string2, jSONObject, httpServletRequest, httpServletResponse);
                        return bl;
                    }
                    case "push": {
                        bl = this.h(string2, jSONObject, httpServletRequest, httpServletResponse);
                        return bl;
                    }
                }
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (JSONException jSONException) {
            String string4 = "Failed parsing request data, device UUID = " + string2;
            ILog.SEVERE(this.getClass(), (String)string4, (Object[])new Object[]{httpServletRequest, jSONException});
            throw new IOException(string4, jSONException);
        }
    }

    private String[] a(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            Enumeration enumeration = httpServletRequest.getHeaders("Authentication");
            while (enumeration.hasMoreElements()) {
                String string2 = ((String)enumeration.nextElement()).trim();
                int n = string2.indexOf(32);
                if (n <= 0 || !string2.substring(0, n).equalsIgnoreCase("Basic")) continue;
                String string3 = new String(Utilities.decodeBase64((String)string2.substring(n + 1).trim()), Utilities.UTF8);
                if ((n = string3.indexOf(58)) < 0) {
                    ILog.SEVERE(this.getClass(), (String)("Basic Authorization (\"" + string3 + "\") does not specify password for request " + String.valueOf(httpServletRequest.getRequestURL()) + " from " + httpServletRequest.getRemoteAddr()), (Object)enumeration);
                    break;
                }
                return new String[]{string3.substring(0, n).trim().toLowerCase(Locale.ENGLISH), string3.substring(n + 1)};
            }
            ILog.SEVERE(this.getClass(), (String)("Request " + String.valueOf(httpServletRequest.getRequestURL()) + " from " + httpServletRequest.getRemoteAddr() + " is not authenticated"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ILog.SEVERE(this.getClass(), (String)("Basic Authorization Base64 decoding failed for request " + String.valueOf(httpServletRequest.getRequestURL()) + " from " + httpServletRequest.getRemoteAddr()), (Throwable)illegalArgumentException);
        }
        PushNotificationHandler.a(httpServletResponse);
        return null;
    }

    private static void a(HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setHeader("WWW-Authenticate", "Basic realm=\"Push Notifications\"");
        httpServletResponse.sendError(401, "Unauthorized");
    }

    private static void a(JSONObject jSONObject, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setCharacterEncoding("UTF-8");
        httpServletResponse.setContentType("application/json;charset=utf-8");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache");
        byte[] byArray = jSONObject.toString().getBytes(StandardCharsets.UTF_8);
        httpServletResponse.setContentLength(byArray.length);
        Throwable throwable = null;
        Object var4_5 = null;
        try (ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();){
            servletOutputStream.write(byArray);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean a(String string, JSONObject jSONObject, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string2 = jSONObject.optString("a", "");
        jSONObject = null;
        if (string2.isEmpty() || string2.startsWith("*")) {
            string2 = "*";
            String string3 = SystemApp.getPublicVAPIDKey();
            if (string3 == null) {
                httpServletResponse.sendError(410, SERVER_NO_KEYS);
                return true;
            }
            jSONObject = new JSONObject();
            jSONObject.put("v", (Object)string3);
        } else {
            String string4;
            AppFactory appFactory = this.a.getApplication(string2);
            if (appFactory == null) {
                httpServletResponse.sendError(410, APP_ID_NOT_FOUND);
                return true;
            }
            PushProps pushProps = appFactory.getModuleProjects()[0].getPushProps();
            if (pushProps != null && (string4 = pushProps.getPublicVAPIDKey()) != null) {
                jSONObject = new JSONObject();
                jSONObject.put("v", (Object)string4);
            }
            if (jSONObject == null) {
                httpServletResponse.sendError(410, APP_ERR_NO_KEYS);
                return true;
            }
        }
        PushNotificationHandler.a(jSONObject, httpServletResponse);
        return true;
    }

    private boolean b(String string, JSONObject jSONObject, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string2 = "???";
        ILog.INFO(this.getClass(), (String)("REST request: reset push notification subscriptions from domain " + string2 + " for device: " + jSONObject.toString()));
        String string3 = null;
        try {
            string3 = jSONObject.getString("u");
            jSONObject = new JSONObject();
            jSONObject.put("c", this.reset(string3));
            PushNotificationHandler.a(jSONObject, httpServletResponse);
        }
        catch (JSONException jSONException) {
            ILog.SEVERE(this.getClass(), (String)"Failed retrieving the device UUID to reset all its push notification subscriptions", (Throwable)jSONException);
        }
        catch (SQLException sQLException) {
            ILog.SEVERE(this.getClass(), (String)("Failed removing push notification subscriptions for device UUID " + string3), (Throwable)sQLException);
        }
        return true;
    }

    public int reset(String string) throws SQLException {
        return Utilities.getSecureRandom().nextInt(77) + 11;
    }

    private boolean c(String string, JSONObject jSONObject, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block6: {
            String[] stringArray;
            String string2;
            String string3;
            String string4;
            String string5;
            boolean bl;
            block7: {
                ILog.INFO(this.getClass(), (String)("REST request " + httpServletRequest.getRemoteAddr() + ": get push notification subscriptions count: " + jSONObject.toString()));
                bl = jSONObject.optBoolean("d");
                string5 = null;
                string4 = null;
                string3 = null;
                string2 = null;
                if (bl) {
                    jSONObject = new JSONObject();
                    jSONObject.put("c", this.getSubscriptionCount(string));
                    break block6;
                }
                stringArray = this.a(string, httpServletRequest, httpServletResponse);
                if (stringArray != null) break block7;
                return true;
            }
            try {
                string5 = stringArray[0];
                string4 = stringArray[1];
                string3 = jSONObject.optString("a");
                if (string3 == null || string3.isEmpty()) {
                    string3 = "*";
                }
                string2 = jSONObject.optString("t");
                jSONObject = new JSONObject();
                jSONObject.put("c", this.getSubscriptionCount(string5, string4, string3, string2));
            }
            catch (NotFoundException notFoundException) {
                PushNotificationHandler.a(httpServletResponse);
                return true;
            }
            catch (SQLException sQLException) {
                String string6 = string5 == null ? "for device UUID " + string : "user " + string5 + ", app ID " + string3 + ", topic " + string2;
                ILog.SEVERE(this.getClass(), (String)("Failed getting the count of push notification subscriptions count (reset mode = " + bl + ") for " + string6 + " from " + String.valueOf(httpServletRequest.getRequestURL()) + " requested from device " + string), (Throwable)sQLException);
                httpServletResponse.sendError(500, string6);
                return true;
            }
        }
        PushNotificationHandler.a(jSONObject, httpServletResponse);
        return true;
    }

    public int getSubscriptionCount(String string) throws SQLException {
        if (string.length() != 20) {
            throw new IllegalArgumentException("deviceUUID must be 20 characters long");
        }
        UUID.fromString(string);
        return DBFunctions.execute(connection -> {
            String string2 = "SELECT COUNT(*) FROM IZS.SUBSCRIPTIONS WHERE device_uuid=?";
            Throwable throwable = null;
            Object var4_5 = null;
            try (PreparedStatement preparedStatement = connection.prepareStatement(string2);){
                Integer n;
                ResultSet resultSet;
                Throwable throwable2;
                block19: {
                    preparedStatement.setString(1, string);
                    throwable2 = null;
                    Object var7_10 = null;
                    resultSet = preparedStatement.executeQuery();
                    n = resultSet.next() ? resultSet.getInt(1) : 0;
                    if (resultSet == null) break block19;
                    resultSet.close();
                }
                return n;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        });
    }

    public int getSubscriptionCount(String string, String string2, String string3, String string4) throws SQLException {
        if (string == null) {
            throw new NullPointerException("userID is null");
        }
        if (string2 == null) {
            throw new NullPointerException("password is null");
        }
        if (string3 == null) {
            throw new NullPointerException("appID is null");
        }
        if (string4 == null) {
            throw new NullPointerException("topic is null");
        }
        return DBFunctions.execute(connection -> {
            AuthenticatedUser authenticatedUser = UserAuthentication.getInstance().getUser(connection, string, string2);
            if (authenticatedUser == null) {
                throw new NotFoundException("User ID not found or password doesn't match");
            }
            long l = authenticatedUser.getBasicUserInfo().id;
            String string5 = "SELECT COUNT(*) FROM IZS.SUBSCRIPTIONS WHERE uid=? AND app_id=? AND topic=?";
            Throwable throwable = null;
            Object var10_10 = null;
            try (PreparedStatement preparedStatement = connection.prepareStatement(string5);){
                Integer n;
                ResultSet resultSet;
                Throwable throwable2;
                block20: {
                    preparedStatement.setLong(1, l);
                    preparedStatement.setString(2, string3);
                    preparedStatement.setString(3, string4);
                    throwable2 = null;
                    Object var13_15 = null;
                    resultSet = preparedStatement.executeQuery();
                    n = resultSet.next() ? resultSet.getInt(1) : 0;
                    if (resultSet == null) break block20;
                    resultSet.close();
                }
                return n;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        });
    }

    private boolean d(String string, JSONObject jSONObject, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        JSONObject jSONObject2 = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        jSONObject2.put("subscriptions", (Object)jSONArray);
        httpServletResponse.sendError(410, APP_ID_NOT_FOUND);
        return true;
    }

    private boolean e(String string, JSONObject jSONObject, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        AppFactory appFactory;
        String string2 = jSONObject.optString("a", "");
        String string3 = jSONObject.optString("t", "");
        String string4 = "Request register push subscriptions for " + httpServletRequest.getRemoteAddr() + ", appID = '" + string2 + "', topic = '" + string3 + "'";
        ILog.INFO(this.getClass(), (String)(string4 + " received"));
        if (string2.isEmpty() || string2.startsWith("*")) {
            string2 = "*";
            var5_8 = SystemApp.getPublicVAPIDKey();
            if (var5_8 == null) {
                httpServletResponse.sendError(410, SERVER_NO_KEYS);
                return true;
            }
        } else {
            appFactory = this.a.getApplication(string2);
            if (appFactory == null) {
                httpServletResponse.sendError(410, APP_ID_NOT_FOUND);
                return true;
            }
            Object object = appFactory.getModuleProjects()[0].getPushProps();
            if (object == null || (var5_8 = object.getPublicVAPIDKey()) == null) {
                httpServletResponse.sendError(410, APP_ERR_NO_KEYS);
                return true;
            }
        }
        if ((appFactory = jSONObject.optJSONObject("s")) == null) {
            httpServletResponse.sendError(400, NO_SUBSCRIPTIONS_ERR);
            return true;
        }
        System.out.println("=====\nRegister subscriptions for " + httpServletRequest.getRemoteAddr() + ", appID = '" + string2 + "', topic = '" + string3 + "':");
        for (Object object : appFactory.keySet()) {
            JSONObject jSONObject2 = appFactory.optJSONObject((String)object);
            if (jSONObject2 == null) {
                String string5 = "Invalid subscription: provider " + (String)object + " data not present";
                ILog.WARNING(this.getClass(), (String)(string5 + ": " + string4 + " failed: " + string5));
                httpServletResponse.sendError(400, string5);
                return true;
            }
            System.out.println(" - provider '" + (String)object + "' => " + jSONObject2.toString(2));
        }
        System.out.println("=====\n");
        jSONObject.put("ok", true);
        PushNotificationHandler.a(jSONObject, httpServletResponse);
        return true;
    }

    private boolean f(String string, JSONObject jSONObject, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        AppFactory appFactory;
        String string2 = jSONObject.optString("a", "");
        String string3 = jSONObject.optString("t", "");
        String string4 = "Request cancel push subscriptions for " + httpServletRequest.getRemoteAddr() + ", appID = '" + string2 + "', topic = '" + string3 + "'";
        ILog.INFO(this.getClass(), (String)(string4 + "  received"));
        if (string2.isEmpty() || string2.startsWith("*")) {
            string2 = "*";
            var5_8 = SystemApp.getPublicVAPIDKey();
            if (var5_8 == null) {
                httpServletResponse.sendError(410, SERVER_NO_KEYS);
                return true;
            }
        } else {
            appFactory = this.a.getApplication(string2);
            if (appFactory == null) {
                httpServletResponse.sendError(410, APP_ID_NOT_FOUND);
                return true;
            }
            Object object = appFactory.getModuleProjects()[0].getPushProps();
            if (object == null || (var5_8 = object.getPublicVAPIDKey()) == null) {
                httpServletResponse.sendError(410, APP_ERR_NO_KEYS);
                return true;
            }
        }
        if ((appFactory = jSONObject.optJSONObject("s")) == null) {
            httpServletResponse.sendError(400, NO_SUBSCRIPTIONS_ERR);
            return true;
        }
        System.out.println("=====\nCancel subscriptions for " + httpServletRequest.getRemoteAddr() + ", appID = '" + string2 + "', topic = '" + string3 + "':");
        for (Object object : appFactory.keySet()) {
            JSONObject jSONObject2 = appFactory.optJSONObject((String)object);
            if (jSONObject2 == null) {
                String string5 = "Invalid subscription: provider " + (String)object + " data not present";
                ILog.WARNING(this.getClass(), (String)(string5 + ": " + string4 + " failed: " + string5));
                httpServletResponse.sendError(400, string5);
                return true;
            }
            System.out.println(" - provider '" + (String)object + "' => " + jSONObject2.toString(2));
        }
        System.out.println("=====\n");
        jSONObject = new JSONObject();
        jSONObject.put("ok", true);
        PushNotificationHandler.a(jSONObject, httpServletResponse);
        return true;
    }

    private boolean g(String string, JSONObject jSONObject, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        AppFactory appFactory;
        String[] stringArray = this.a(string, httpServletRequest, httpServletResponse);
        if (stringArray == null) {
            return true;
        }
        String string2 = jSONObject.optString("app_id");
        if (string2 == null) {
            httpServletResponse.sendError(400, "Missing 'app_id' member");
            return true;
        }
        String string3 = jSONObject.optString("topic");
        if (string3 == null) {
            httpServletResponse.sendError(400, "Missing 'topic' member");
            return true;
        }
        if (string2.isEmpty() || string2.startsWith("*")) {
            string2 = "*";
            String string4 = SystemApp.getPublicVAPIDKey();
            if (string4 == null) {
                httpServletResponse.sendError(410, SERVER_NO_KEYS);
                return true;
            }
        } else {
            String string5;
            appFactory = this.a.getApplication(string2);
            if (appFactory == null) {
                httpServletResponse.sendError(410, APP_ID_NOT_FOUND);
                return true;
            }
            PushProps pushProps = appFactory.getModuleProjects()[0].getPushProps();
            if (pushProps == null || (string5 = pushProps.getPublicVAPIDKey()) == null) {
                httpServletResponse.sendError(410, APP_ERR_NO_KEYS);
                return true;
            }
        }
        jSONObject = new JSONObject();
        jSONObject.put("c", this.b++ % 2 == 0 || "123".equals(string3) || string3.isEmpty());
        appFactory = new JSONArray();
        jSONObject.put("s", (Object)appFactory);
        PushNotificationHandler.a(jSONObject, httpServletResponse);
        return true;
    }

    private boolean h(String string, JSONObject jSONObject, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string2 = jSONObject.optString("a", "");
        String string3 = jSONObject.optString("t", "");
        if (string2.isEmpty() || string2.startsWith("*")) {
            string2 = "*";
            String string4 = SystemApp.getPublicVAPIDKey();
            if (string4 == null) {
                httpServletResponse.sendError(410, SERVER_NO_KEYS);
                return true;
            }
        } else {
            String string5;
            AppFactory appFactory = this.a.getApplication(string2);
            if (appFactory == null) {
                httpServletResponse.sendError(410, APP_ID_NOT_FOUND);
                return true;
            }
            PushProps pushProps = appFactory.getModuleProjects()[0].getPushProps();
            if (pushProps == null || (string5 = pushProps.getPublicVAPIDKey()) == null) {
                httpServletResponse.sendError(410, APP_ERR_NO_KEYS);
                return true;
            }
        }
        jSONObject = new JSONObject();
        jSONObject.put("c", Utilities.getSecureRandom().nextInt(77) + 11);
        PushNotificationHandler.a(jSONObject, httpServletResponse);
        return true;
    }
}

