/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.prop;

import com.iizix.comm.IPortController;
import com.iizix.comm.PortConfig;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IWebServerPortConfig;
import com.iizix.prop.PKCS12IdentityProp;
import com.iizix.prop.PasswordProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.server.acme.LetsEncryptDomain;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WebServerPortConfig
extends PropCnr
implements IWebServerPortConfig {
    public static final String PORT = "port";
    public static final String PROTOCOL = "protocol";
    public static final String HTTP2 = "http2";
    public static final String HTTP3 = "http3";
    public static final String BIND_ADDRESS = "bindAddress";
    public static final String FRONT_END_SECURED = "frontEndSecured";
    public static final String EXTERNAL_HOST_NAME = "externalHostName";
    public static final String UDP_PORT = "udpPort";
    public static final String EXTERNAL_PORT = "externalPort";
    public static final String ID_PKCS12 = "idPKCS12";
    public static final String ID_PASSWORD = "idPassword";
    public static final String DOMAIN_NAMES = "domainNames";
    public static final String LETS_ENCRYPT_DOMAINS = "letsEncryptDomain";
    public static final String DEFAULT_PASSWORD = "changeit";
    public static final String EXCLUDE_TLS_VERSION = "excludeTLSVersion";
    private static final Object[] a = new Object[]{new String[0], new String[]{"TLSv1"}, new String[]{"TLSv1", "TLSv1.1"}};
    private HashMap<String, Object> a;
    private PortConfig a;

    public WebServerPortConfig() {
    }

    public WebServerPortConfig(Atom atom) {
        super(atom);
    }

    protected GProp<?> convertLoadedProp(GProp<?> gProp) throws PropException {
        String string = gProp.getPropName();
        if (string.equals("port.start")) {
            gProp.renameProp2(Atom.get((String)PORT));
        } else if (string.equals("port.end")) {
            return null;
        }
        return gProp;
    }

    public String getType() {
        return this.isLocalHTTP() ? "HTTP" : "HTTPS";
    }

    public boolean isFrontEndSecured() {
        return this.getBool(FRONT_END_SECURED);
    }

    public String getDescription() {
        String string = this.getString(Atom.DESCR);
        return string != null && !string.isEmpty() ? string : null;
    }

    public String getPortDescription() {
        Set<String> set;
        int n;
        int n2 = this.getPort();
        StringBuilder stringBuilder = new StringBuilder("Port ").append(n2).append(", ").append(this.getType());
        String string = this.getBindAddress();
        if (string != null) {
            stringBuilder.append(", bind ").append(string);
        }
        if (this.isFrontEndSecured()) {
            stringBuilder.append(", front-end secured");
        }
        if ((string = this.getExternalHostName()) != null) {
            stringBuilder.append(", external host name ").append(string);
        }
        if ((n2 = this.getExternalPort()) > 0) {
            stringBuilder.append(", external port ").append(n2);
        }
        if ((n = (set = this.getDomainNamesSet()).size()) == 1) {
            stringBuilder.append(", domain ").append(set.iterator().next());
        } else if (n == 2) {
            stringBuilder.append(", domains ").append(set.stream().collect(Collectors.joining(" ")));
        }
        string = this.getDescription();
        if (string != null) {
            stringBuilder.append(", description ").append(string);
        }
        return stringBuilder.toString();
    }

    public WebServerPortConfig clone() {
        try {
            WebServerPortConfig webServerPortConfig = (WebServerPortConfig)super.clone();
            webServerPortConfig.a = null;
            return webServerPortConfig;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public int getPort() {
        int n = this.getInt(PORT);
        return n > 0 && n < 65535 ? n : (this.isLocalHTTP() ? 80 : 443);
    }

    public boolean useHTTP2() {
        return this.getBool(HTTP2, true);
    }

    public boolean useHTTP3() {
        return this.useHTTP2() && this.getBool(HTTP3);
    }

    public int getUDPPort() {
        int n = this.getInt(UDP_PORT);
        return n > 0 && n < 65535 ? n : this.getPort();
    }

    public int getProtocol() {
        int n = this.getInt(PROTOCOL, 0);
        return n >= 0 && n <= 1 ? n : 0;
    }

    public String getBindAddress() {
        String string = this.getString(BIND_ADDRESS);
        return string != null && !string.isEmpty() ? string : null;
    }

    public String getExternalHostName() {
        String string = this.getString(EXTERNAL_HOST_NAME);
        return string != null && !string.isEmpty() ? string : null;
    }

    public int getExternalPort() {
        int n = this.getInt(EXTERNAL_PORT);
        return n > 0 && n < 65535 ? n : 0;
    }

    public String getKeyStorePassword() {
        PasswordProp passwordProp = (PasswordProp)this.getProp(ID_PASSWORD, PasswordProp.class);
        return passwordProp != null ? (String)passwordProp.getPropValue() : null;
    }

    public KeyStore getKeyStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableEntryException {
        return this.getKeyStore(null);
    }

    public KeyStore getKeyStore(StringBuilder stringBuilder) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableEntryException {
        KeyStore keyStore;
        HashSet<String> hashSet = new HashSet<String>(this.getLetsEncryptDomainNamesSet());
        HashSet<String> hashSet2 = new HashSet<String>(this.getDomainNamesSet());
        hashSet2.removeAll(hashSet);
        if (hashSet.size() == 1 && hashSet2.isEmpty()) {
            LetsEncryptDomain letsEncryptDomain = this.getLetsEncryptDomain(hashSet.iterator().next());
            return letsEncryptDomain != null ? letsEncryptDomain.getKeyStore(stringBuilder) : null;
        }
        PKCS12IdentityProp pKCS12IdentityProp = (PKCS12IdentityProp)this.getProp(ID_PKCS12, PKCS12IdentityProp.class);
        String string = this.getKeyStorePassword();
        KeyStore keyStore2 = keyStore = string != null ? pKCS12IdentityProp.getKeyStore(string.toCharArray()) : null;
        if (string == null) {
            string = DEFAULT_PASSWORD;
        }
        if (!hashSet.isEmpty()) {
            HashSet<String> hashSet3 = new HashSet<String>();
            if (keyStore != null) {
                hashSet3.addAll(Collections.list(keyStore.aliases()));
            } else {
                keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(null, null);
            }
            KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(string.toCharArray());
            LetsEncryptDomain[] letsEncryptDomainArray = this.getLetsEncryptDomains();
            int n = letsEncryptDomainArray.length;
            int n2 = 0;
            while (n2 < n) {
                LetsEncryptDomain letsEncryptDomain = letsEncryptDomainArray[n2];
                StringBuilder stringBuilder2 = new StringBuilder();
                KeyStore keyStore3 = letsEncryptDomain.getKeyStore(stringBuilder2);
                if (keyStore3 != null) {
                    KeyStore.PasswordProtection passwordProtection2 = new KeyStore.PasswordProtection(stringBuilder2.toString().toCharArray());
                    for (String string2 : Collections.list(keyStore3.aliases())) {
                        KeyStore.Entry entry = keyStore3.getEntry(string2, passwordProtection2);
                        String string3 = letsEncryptDomain.getDomain().replace('*', 'X');
                        Object object = string3;
                        int n3 = 2;
                        while (!hashSet3.add((String)object)) {
                            object = string3 + "-" + n3;
                            ++n3;
                        }
                        keyStore.setEntry((String)object, entry, passwordProtection);
                    }
                }
                ++n2;
            }
        }
        if (stringBuilder != null) {
            stringBuilder.setLength(0);
            stringBuilder.append(string);
        }
        return keyStore;
    }

    public synchronized <T> T setProperty(String string, T t, Class<T> clazz) throws ClassCastException {
        if (this.a == null) {
            if (t == null) {
                return null;
            }
            this.a = new HashMap();
        }
        Object object = t != null ? this.a.put(string, t) : this.a.remove(string);
        return clazz.cast(object);
    }

    public synchronized <T> T getProperty(String string, Class<T> clazz) throws ClassCastException {
        if (this.a == null) {
            this.a = new HashMap();
        }
        Object v = this.a.get(string);
        return clazz.cast(v);
    }

    public String getDomainNames() {
        String string = this.getString(DOMAIN_NAMES);
        return string != null ? string.trim().toLowerCase() : null;
    }

    public Set<String> getDomainNamesSet() {
        String string = this.getDomainNames();
        if (string == null || string.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.isEmpty()) continue;
            linkedHashSet.add(string2);
        }
        return linkedHashSet;
    }

    public String getLetsEncryptDomainNames() {
        String string = this.getString(LETS_ENCRYPT_DOMAINS);
        return string != null ? string.trim().toLowerCase() : null;
    }

    public Set<String> getLetsEncryptDomainNamesSet() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        String string = this.getLetsEncryptDomainNames();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.isEmpty()) continue;
                linkedHashSet.add(string2);
            }
        }
        return linkedHashSet;
    }

    public LetsEncryptDomain[] getLetsEncryptDomains() {
        ArrayList<LetsEncryptDomain> arrayList = new ArrayList<LetsEncryptDomain>();
        PropCnr propCnr = this.getParent();
        if (propCnr != null) {
            for (String string : this.getLetsEncryptDomainNamesSet()) {
                LetsEncryptDomain letsEncryptDomain = (LetsEncryptDomain)propCnr.getProp(string, LetsEncryptDomain.class);
                if (letsEncryptDomain == null) continue;
                arrayList.add(letsEncryptDomain);
            }
        }
        return arrayList.toArray(new LetsEncryptDomain[arrayList.size()]);
    }

    public LetsEncryptDomain getLetsEncryptDomain(String string) {
        PropCnr propCnr = this.getParent();
        return propCnr != null ? (LetsEncryptDomain)propCnr.getProp(string, LetsEncryptDomain.class) : null;
    }

    public void setConfig(PortConfig portConfig) {
        this.a = portConfig;
    }

    public void restartConnector() {
        PortConfig portConfig = this.a;
        if (portConfig != null) {
            portConfig.restartConnector();
        }
    }

    public IPortController getController() {
        PortConfig portConfig = this.a;
        return portConfig != null ? portConfig.controller : null;
    }

    public String[] getExcludedSecureProtocols() {
        int n = Math.min(2, Math.max(0, this.getInt(EXCLUDE_TLS_VERSION, 2)));
        return (String[])a[n];
    }
}

