/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.value.IValueObject;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.w3c.dom.Element;

public abstract class NumberValue<TYPE extends Number>
implements IValueObject<TYPE> {
    @Override
    public final boolean isRightAligned() {
        return true;
    }

    @Override
    public final NumberFormat getFormatter(String string, LocaleInfo localeInfo) throws IllegalArgumentException {
        if (string == null) {
            return null;
        }
        if (localeInfo == null) {
            localeInfo = LocaleInfo.getCurrent(true);
        }
        switch (string) {
            case "integer": {
                return localeInfo.createIntegerFormat();
            }
            case "percent": {
                return localeInfo.createPercentFormat();
            }
            case "currency": {
                return localeInfo.createCurrencyFormat();
            }
        }
        DecimalFormat decimalFormat = localeInfo.createDecimalFormat();
        decimalFormat.applyPattern(string);
        return decimalFormat;
    }

    @Override
    public final String toString(TYPE TYPE) {
        return TYPE.toString();
    }

    @Override
    public final String toString(TYPE TYPE, String string, LocaleInfo localeInfo) throws Exception {
        if (string != null && !string.isEmpty()) {
            NumberFormat numberFormat = this.getFormatter(string, localeInfo);
            return numberFormat.format(TYPE);
        }
        return TYPE.toString();
    }

    @Override
    public final TYPE parse(String string, String string2, LocaleInfo localeInfo) throws ParseException, Exception {
        NumberFormat numberFormat = this.getFormatter(string2, localeInfo);
        if (numberFormat == null) {
            try {
                return (TYPE)this.parse(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Text \"" + string + "\": not " + this.getDescription(), 0);
            }
        }
        return (TYPE)((Number)this.convert(numberFormat.parseObject(string), this.getValueType(), localeInfo));
    }

    @Override
    public abstract TYPE parse(String var1) throws NumberFormatException;

    @Override
    public final TYPE load(String string, Element element) throws ParseException {
        try {
            return (TYPE)this.parse(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException.getMessage(), 0);
        }
    }

    @Override
    public final String save(TYPE TYPE, Element element) {
        return TYPE.toString();
    }

    @Override
    public final long asLong(TYPE TYPE, LocaleInfo localeInfo) {
        return Long.MIN_VALUE;
    }
}

