/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.webserver;

import com.iizigo.webserver.Preference;
import com.iizix.ILog;
import com.iizix.Utilities;
import com.iizix.jetty.IExternalBrowserPages;
import com.iizix.jetty.IWSFileProviderServer;
import com.iizix.jetty.IntegratedWebServer;
import com.iizix.jetty.WSHelper;
import com.iizix.js.JSFiles;
import com.iizix.nio.WebSocketAcceptor;
import com.iizix.server.oauth.OAuthEngine;
import com.iizix.text.HTMLUtilities;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class InternalWebServer
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.iizigo.webserver";
    private static InternalWebServer a;
    static BundleContext a;
    static String a;
    private IntegratedWebServer a;
    private final Map<String, File> a = new ConcurrentHashMap();

    public void start(BundleContext bundleContext) throws Exception {
        ILog.INFO(InternalWebServer.class, (String)"Starting Web Server plug-in");
        super.start(bundleContext);
        a = this;
        a = bundleContext;
    }

    public static InternalWebServer getInstance() {
        return a;
    }

    public int startWebServer(File file, IExternalBrowserPages iExternalBrowserPages, IWSFileProviderServer iWSFileProviderServer, WebSocketAcceptor webSocketAcceptor) {
        Object object;
        Object object2;
        String string2;
        if (this.a != null) {
            ILog.SEVERE(((Object)((Object)this)).getClass(), (String)"Failed starting web server: it is already running");
            return 0;
        }
        this.a.clear();
        for (String string2 : JSFiles.getRootFiles()) {
            object2 = JSFiles.getFile((String)string2);
            if (object2 == null) continue;
            this.a.put(string2, object2);
        }
        string2 = JSFiles.getRoot(null).getAbsolutePath();
        Preference preference = Preference.getInstance();
        object2 = null;
        String string3 = null;
        if (!preference.keyStore.isEmpty()) {
            try {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                object = null;
                File file2 = new File(preference.keyStore);
                Throwable throwable = null;
                Object var13_17 = null;
                try (FileInputStream fileInputStream = new FileInputStream(file2);){
                    int n = fileInputStream.available();
                    if ((long)n != file2.length()) {
                        throw new IOException("Different file size and data");
                    }
                    object = new byte[n];
                    if (fileInputStream.read((byte[])object) != n) {
                        throw new IOException("Different file size and data");
                    }
                    keyStore.load(new ByteArrayInputStream((byte[])object), preference.password.toCharArray());
                    object2 = keyStore;
                    string3 = preference.password;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
                ILog.SEVERE(((Object)((Object)this)).getClass(), (String)("Failed loading the PKCS#12 keystore file \"" + preference.keyStore + "\" for SSL"), (Throwable)exception);
            }
        }
        ILog.INFO(((Object)((Object)this)).getClass(), (String)("Starting integrated web server with root " + string2));
        int n = 0;
        try {
            object = new IntegratedWebServer(file, (Map)((Object)this.a), string2);
            n = object.startWebServer(iExternalBrowserPages, iWSFileProviderServer, webSocketAcceptor, preference.extServerURL, preference.createPortConfigs(), (KeyStore)object2, string3, preference.useGzip);
            OAuthEngine.initializeNewInstance((String)WSHelper.getExternalBaseServerURL((String)preference.extServerURL, (String)preference.bindAddress, (int)object.getWebServerPort(), (int)object.getWebServerPort(), (boolean)false));
            if (n != 0) {
                this.a = object;
            }
        }
        catch (Throwable throwable) {
            ILog.SEVERE(((Object)((Object)this)).getClass(), (String)"Failed starting the integrated web server", (Throwable)throwable);
        }
        return n;
    }

    public boolean stopWebServer(long l) {
        IntegratedWebServer integratedWebServer = this.a;
        return integratedWebServer != null && integratedWebServer.stopWebServer(l);
    }

    public int getWebServerPort() {
        IntegratedWebServer integratedWebServer = this.a;
        return integratedWebServer != null ? integratedWebServer.getWebServerPort() : 0;
    }

    public int getSecureWebServerPort() {
        IntegratedWebServer integratedWebServer = this.a;
        return integratedWebServer != null ? integratedWebServer.getSecureWebServerPort() : 0;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (!this.stopWebServer(5000L)) {
            ILog.WARNING(InternalWebServer.class, (String)"Failed to stop web server within 5 seconds, exiting anyway...");
        }
        a = null;
        a = null;
        ILog.INFO(InternalWebServer.class, (String)"Web Server plug-in stopped");
        super.stop(bundleContext);
    }

    public String getHTTPFileUrl(String string) {
        File file = JSFiles.getRoot(null);
        if (!string.isEmpty() && !new File(file, string).exists()) {
            throw new InternalError("File not found: " + string);
        }
        return "http://127.0.0.1:" + this.getWebServerPort() + "/" + string;
    }

    public String loadHTML(String string) {
        File file = JSFiles.getRoot(null);
        if (string.isEmpty()) {
            throw new InternalError("filename is empty");
        }
        File file2 = new File(file, string);
        try {
            return Files.readString(file2.toPath());
        }
        catch (IOException | InvalidPathException exception) {
            ILog.WARNING(((Object)((Object)this)).getClass(), (String)("Failed loading file " + String.valueOf(file2)), (Throwable)exception);
            return "<!doctype html><html lang=en><head><meta charset=utf-8><title>Error</title></head><body><h1>" + HTMLUtilities.escapeString((String)("File name \"" + String.valueOf(file2) + "\": " + exception.getMessage()), (boolean)false) + "</h1><pre>" + HTMLUtilities.escapeString((String)Utilities.getStackTrace((Throwable)exception), (boolean)false) + "</pre></body></html>";
        }
    }

    public String getFileUrl(String string) {
        File file = JSFiles.getRoot(null);
        if (!string.isEmpty() && !new File(file, string).exists()) {
            throw new InternalError("File not found: " + string);
        }
        try {
            return new File(file, string).getAbsoluteFile().toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return "file:/" + new File(file, string).getAbsolutePath().replace('\\', '/');
        }
    }

    public IntegratedWebServer getServer() {
        return this.a;
    }

    public File getWebServerMapping(String string) {
        return (File)this.a.get(string);
    }
}

